package com.yd.api.user;

import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.yd.api.practitioner.service.PractitionerService;
import com.yd.api.result.JsonResult;
import com.yd.api.security.vo.DESCommonVO;
import com.yd.api.user.service.UserService;
import com.yd.api.user.vo.UserRequestVO;
import com.yd.api.user.vo.UserVO;
import com.yd.util.deshandler.DESTypeHandler;

@RestController
@RequestMapping(value="/user")
public class UserController {

    @Autowired
    private UserService userService;
	
	@RequestMapping("/insert")
	public Object encrypt(@RequestBody UserVO requestVO) throws Exception{
		JsonResult result = new JsonResult();
		int resultNum = 0;
		try {

			resultNum = userService.insert(requestVO);
			
		} catch (Exception e) {
			e.printStackTrace();
		}

		result.setData(resultNum);
		return result;
	}

    @RequestMapping("/findByIds")
	public Object Decrypt(@RequestBody UserRequestVO userRequestVO) throws Exception{
		JsonResult result = new JsonResult();

		List<UserVO> listVO = new ArrayList<UserVO>();
		try {

			listVO = userService.findByIds(userRequestVO.getUserIdList());

		} catch (Exception e) {
			e.printStackTrace();
		}
		result.setData(listVO);
		return result;
	}
}
