package com.yd.dal.entity.customer;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * ag_acl_practitioner_potential_assigned_track
 * @author 
 */
@Data
public class AclPractitionerPotentialAssignedTrack implements Serializable {
    /**
     * serial id
     */
    private Long id;

    /**
     * FK ag_mkt_practitioner_potential.id 线索指派表
     */
    private Long practitionerPotentialId;

    /**
     * FK ag_acl_practitioner.id 指派团队长id
     */
    private Long practitionerAssignedId;

    /**
     * FK ag_md_drop_options.id 团队长增员状态
     */
    private Long trackStatusId;

    /**
     * 潜在经纪人增员(团队长)类似回访记录
     */
    private String notice;

    /**
     * 0=No, 1=Yes
     */
    private Integer isActive;

    /**
     * 分析建置时间
     */
    private Date createdAt;

    /**
     * 建置者 FK ag_acl_user.id
     */
    private Long createdBy;

    /**
     * 更新时间
     */
    private Date updatedAt;

    /**
     * 更新者 FK ag_acl_user.id
     */
    private Long updatedBy;

    private Integer creatorType;

    private Integer updatorType;

    private static final long serialVersionUID = 1L;
}