package com.yd.dal.service.customer;

import com.yd.api.practitioner.vo.payscale.PayScaleInfo;
import com.yd.dal.entity.practitioner.opportunity.PlayerSalesActivityInfo;
import com.yd.dal.entity.practitioner.opportunity.OwnOpportunityInfo;
import com.yd.dal.entity.customer.AclPractitioner;
import com.yd.dal.entity.customer.practitioner.PractitionerBasicInfo;
import com.yd.dal.entity.customer.practitioner.PractitionerInfo;
import com.yd.dal.entity.customer.practitioner.PractitionerRankInfo;
import com.yd.dal.entity.practitioner.payscale.PayScaleBasicInfo;
import org.springframework.stereotype.Service;

import java.util.List;

@Service("aclPractitionerDALService")
public interface AclPractitionerDALService {
    /**
     * 通过customerId 和is_active 获取用户
     * @param customerId
     * @param i
     * @return
     */
    AclPractitioner findByCustomerIdIsActive(Long customerId, int i);

    /**
     * 线下--通过手机号码获取经纪人的基础信息
     * @param mobileNo
     * @return
     */
    PractitionerBasicInfo getPractitionerBasicInfoForOffline(String mobileNo);
    /**
     * 线上--通过手机号码获取经纪人的基础信息
     * @param mobileNo
     * @return
     */
    PractitionerBasicInfo getPractitionerBasicInfoForOnline(String mobileNo);

    /**
     * 线下--按照时间进行查询经纪人的排名统计信息
     * @param time 1-month,2-year
     * @return
     */
    List<PractitionerRankInfo> getPractitionerRankInfoForOffline(Integer time);

    /**
     * 线上--按照时间进行查询经纪人的排名统计信息
     * @param time 1-month,2-year
     * @return
     */
    List<PractitionerRankInfo> getPractitionerRankInfoForOnline(Integer time,Long practitionerTypeId);

    /**
     * 线上--按照时间进行查询特殊人员的排名统计信息
     * @param mobileSpecials
     * @return
     */
    List<PractitionerRankInfo> getPractitionerRankInfoForSpecials(List<String> mobileSpecials,Integer time);

    /**
     * 经纪人基本信息查询
     * @param mobileNo
     * @return
     */
    PractitionerInfo findPractitionerInfoByLogin(String mobileNo);

    /**
     * 通过经纪人id查找经纪人
     * @param practitionerId
     * @return
     */
    AclPractitioner findPractitionerById(Long practitionerId);

    /**
     * 经纪人查询自己的商机
     * @param practitionerId
     * @return
     */
    List<OwnOpportunityInfo> ownOpportunityQuery(Long practitionerId);
    void updatePractitioner(AclPractitioner practitioner);

    /**
     * 通过id数组查询
     * @param practitionerIdList
     * @return
     */
    List<AclPractitioner> findByIds(List<Long> practitionerIdList);

    /**
     * 通过团队长经纪人id查询团队旗下所有经纪人
     * @param practitionerId
     * @return
     */
    List<AclPractitioner> findForSubordinateIdByPractitionerId(Long practitionerId);

    /**
     * 通过团队长经纪人id查询团队中组员的销售活动量(跟进分数,除去以失败的跟进)
     * @param practitionerId
     * @return
     */
    List<PlayerSalesActivityInfo> playerSalesActivityQuery(Long practitionerId, Long optionsId);
    /**
     * 根据体系id查询经纪人
     * @param subordinateSystemId 体系id
     * @return
     */
    List<AclPractitioner> findBySubordinateSystemId(Long subordinateSystemId);

    /**
     * 更具经纪人id查询该经纪人手机号码
     * @param practitionerId 经纪人id
     * @return 查询结果
     */
    String findMobileNoByPractitionerId(Long practitionerId);

    /**
     * EGolden -- 根据手机号码查询经纪人的基本信息
     * @param mobileNo 手机号码
     * @return 查询结果
     */
    PractitionerBasicInfo findByMobileNoE(String mobileNo);

    /**
     * 根据id查询经纪人信息
     * @param practitionerId 经纪人id
     * @return 查询结果
     */
    AclPractitioner findById(Long practitionerId);

    /**
     * EGolden -- 根据practitionerId和时间段查询
     * @param practitionerIdEG 经纪人id
     * @param time 时间
     * @return 返回结果
     */
    PractitionerRankInfo getPractitionerRankInfoByPractitionerIdEG(String practitionerIdEG, Integer time);

    /**
     * YD -- 根据practitionerId和时间段查询
     * @param practitionerId 经纪人id
     * @param time 时间
     * @return 返回结果
     */
    PractitionerRankInfo getPractitionerRankInfoByPractitionerIdYD(Long practitionerId, Integer time);

    /**
     * eGolden -- 根据经纪人id获取薪资表列表
     * @param practitionerIdEG 经纪人id
     * @return 结果
     */
    List<PayScaleInfo> findPayScaleByPractitionerEG(String practitionerIdEG);

    /**
     * 查询经纪人薪资文件路径
     * @param monShId 流水号
     * @return 结果
     */
    PayScaleBasicInfo findFilePathByMonShId(Integer monShId);

    /**
     * 根据EGolden查询
     * @param practitionerIdEG id
     * @return 返回
     */
    PractitionerBasicInfo findByIdEG(String practitionerIdEG);

    /**
     * 通过指派经纪人id,查询经纪人详情
     * @param leadsAssignedId
     * @return
     */
    AclPractitioner findPractitionerByLeadsAssignedId(Long leadsAssignedId);

    /**
     * 查询所有经纪人
     * @return 结果
     */
    List<AclPractitioner> findAll();

    int isTeamLeader(Long practitionerId);

    List<Long> queryTeamAllPractitionerId(Long practitionerId);

    List<Long> queryMentoredByPractitionerId(Long practitionerId);

    void save(AclPractitioner practitioner);

    PractitionerInfo findPractitionerInfoByPractitionerId(Long practitionerId);
}
