package com.yd.api.practitioner.service.impl;

import com.yd.api.practitioner.service.ScheduleTrackService;
import com.yd.api.practitioner.vo.organization.OrganizationQueryResponseVO;
import com.yd.api.result.JsonResult;
import com.yd.dal.entity.practitioner.ScheduleTrack;
import com.yd.dal.mapper.marketing.ScheduleTrackMapper;
import com.yd.util.CommonUtil;
import com.yd.util.config.ZHBErrorConfig;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Service
public class ScheduleTrackServiceImpl implements ScheduleTrackService {
    @Autowired
    private ScheduleTrackMapper scheduleTrackMapper;

    @Override
    public JsonResult insert(ScheduleTrack schedule) {
        JsonResult result = new JsonResult();
        result.setSuccess(false);
        try {
            String taskTimeFrom = schedule.getTaskTimeFrom();
            String taskTimeEnd = schedule.getTaskTimeEnd();
            Long practitionerId = schedule.getPractitionerId();
            // 判断活动时间段是否冲突
            if (!CommonUtil.isNullOrBlank(taskTimeFrom) && !CommonUtil.isNullOrBlank(taskTimeEnd)) {
                int count = scheduleTrackMapper.checkTimePeriodConflict(taskTimeFrom, taskTimeEnd, practitionerId);
                if (count > 0) {
                    result.setMessage(ZHBErrorConfig.getErrorInfo("830020"));
                    return result;
                }
            } else {
                result.setMessage("taskTimeFrom,taskTimeEnd不能为空");
                return result;
            }

            schedule.setCreatedBy(practitionerId);
            schedule.setUpdatedBy(practitionerId);
            schedule.setUpdatorType(2);
            schedule.setCreatorType(2);
            Date curTime = new Date();
            schedule.setUpdatedAt(new Date());
            schedule.setCreatedAt(curTime);
            scheduleTrackMapper.insert(schedule);
            result.setSuccess(true);
            result.setMessage(ZHBErrorConfig.getErrorInfo("800000"));
        } catch (Exception e) {
            e.printStackTrace();
            result.setMessage(e.getMessage());
        }
        return result;
    }

    @Override
    public JsonResult queryScheduleTrackList(Long practitionerId, String trackDate) {
        JsonResult result = new JsonResult();
        result.setSuccess(false);
        if (StringUtils.isEmpty(trackDate) || null == practitionerId) {
            result.setMessage("经纪人id和查询时间不能为空");
            return result;
        }
        List<ScheduleTrack> showList = new ArrayList<>();
        try {
            List<ScheduleTrack> dataList = scheduleTrackMapper.queryScheduleTrackList(practitionerId);
            for (ScheduleTrack schedule: dataList) {
                if (this.checkFixedDay(trackDate, schedule)) {
                    showList.add(schedule);
                }
            }
            result.setData(showList);
            result.setSuccess(true);
            result.setMessage(ZHBErrorConfig.getErrorInfo("800000"));
        } catch (Exception e) {
            e.printStackTrace();
            result.setMessage(e.getMessage());
        }
        return result;
    }

    private boolean checkFixedDay(String trackDate, ScheduleTrack track) {
        Date date = CommonUtil.stringParseDate(trackDate, "yyyy-MM-dd");
        String week = CommonUtil.getWeekOfDate(date);
        String trackTime = CommonUtil.dateParseString(track.getTrackTime(), "yyyy-MM-dd");
        int flag = 0;
        switch (week) {
            case "周一":
                flag = track.getTaskRoutineAtweek1();
                break;
            case "周二":
                flag = track.getTaskRoutineAtweek2();
                break;
            case "周三":
                flag = track.getTaskRoutineAtweek3();
                break;
            case "周四":
                flag = track.getTaskRoutineAtweek4();
                break;
            case "周五":
                flag = track.getTaskRoutineAtweek5();
                break;
            case "周六":
                flag = track.getTaskRoutineAtweek6();
                break;
            case "周日":
                flag = track.getTaskRoutineAtweek7();
                break;
            default:
                break;
        }
        if (CommonUtil.isToday(trackTime) || flag == 1) {
            return true;
        } else {
            return false;
        }
    }


}
