package com.yd.api.market;

import com.yd.api.result.JsonResult;
import com.yd.api.market.service.MarketService;
import com.yd.api.market.vo.announcement.AnnouncementInfoVO;
import com.yd.api.market.vo.announcement.AnnouncementQueryRequestVO;
import com.yd.api.market.vo.announcement.AnnouncementQueryResponseVO;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class MarketController {

    @Autowired
    private MarketService marketService;

    /**
     * 市场公告查询接口
     * @param requestVO
     * @return AnnouncementQueryResponseVO
     */
    @RequestMapping("/announcementQuery")
    public Object announcementQuery(@RequestBody AnnouncementQueryRequestVO requestVO){
        JsonResult result = new JsonResult();
        AnnouncementQueryResponseVO responseVO = marketService.announcementQuery(requestVO);
        result.setData(responseVO);
        result.addResult(responseVO);
        return result;
    }
    /**
     * 添加案例，返回自增id，以建立关联
     * @param announcementInfoVO
     * @return
     */
    @RequestMapping("/addannouncement")
    public Object addAnnouncement(@RequestBody AnnouncementInfoVO announcementInfoVO){
        JsonResult result = new JsonResult();
        AnnouncementQueryResponseVO responseVO = marketService.addAnnouncement(announcementInfoVO);
        result.setData(responseVO);
        result.addResult(responseVO);
        return result;
    }    
    /**
     * 修改案例
     * @param announcementInfoVO
     * @return
     */
    @RequestMapping("/updateannouncement")
    public Object updateAnnouncement(@RequestBody AnnouncementInfoVO announcementInfoVO){
        JsonResult result = new JsonResult();
        int rows = marketService.update(announcementInfoVO);
        result.setData(rows);
        return result;
    } 
    /**
     * 删除案例
     * @param announcementInfoVO
     * @return
     */
    @RequestMapping("/deleteannouncement")
    public Object deleteAnnouncement(@RequestBody AnnouncementInfoVO announcementInfoVO){
        JsonResult result = new JsonResult();
        int rows = marketService.delete(announcementInfoVO.getAnnouncementType());
        result.setData(rows);
        return result;
    }     
}
