package com.yd.api.agms.service.impl;

import com.github.pagehelper.PageInfo;
import com.yd.api.agms.service.AgmsHiringService;
import com.yd.api.agms.vo.hiring.*;
import com.yd.api.result.CommonResult;
import com.yd.dal.entity.agms.hiring.*;
import com.yd.dal.entity.meta.MdPractitionerHiringApproveSteps;
import com.yd.dal.entity.user.AclUser;
import com.yd.dal.service.agms.AgmsHiringDALService;
import com.yd.dal.service.meta.MdPractitionerHiringApproveStepsDALService;
import com.yd.dal.service.user.AclUserDALService;
import com.yd.rmi.cache.SystemConfigService;
import com.yd.util.CommonUtil;
import com.yd.util.config.ZHBErrorConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author xxy
 */
@Service("agmsHiringService")
public class AgmsHiringServiceImpl implements AgmsHiringService {

    private AgmsHiringDALService agmsHiringDalService;
    private SystemConfigService systemConfigService;
    private AclUserDALService aclUserDalService;
    private MdPractitionerHiringApproveStepsDALService mdPractitionerHiringApproveStepsDalService;

    @Autowired
    public void setAgmsHiringDalService(AgmsHiringDALService agmsHiringDalService){
        this.agmsHiringDalService = agmsHiringDalService;
    }
    @Autowired
    public void setSystemConfigService(SystemConfigService systemConfigService) {
        this.systemConfigService = systemConfigService;
    }
    @Autowired
    public void setMdPractitionerHiringApproveStepsDalService(MdPractitionerHiringApproveStepsDALService mdPractitionerHiringApproveStepsDalService) {
        this.mdPractitionerHiringApproveStepsDalService = mdPractitionerHiringApproveStepsDalService;
    }

    @Autowired
    public void setAclUserDalService(AclUserDALService aclUserDalService) {
        this.aclUserDalService = aclUserDalService;
    }

    @Override
    public PractitionerHiringDetailResponseVO practitionerHiringDetail(PractitionerHiringDetailRequestVO requestVO) {
        PractitionerHiringDetailResponseVO responseVO = new PractitionerHiringDetailResponseVO();

        Long hiringBasicInfoId = requestVO.getHiringBasicInfoId();
        Long loginId = requestVO.getLoginId();
        //经纪人审批基本信息
        PractitionerHiringBasicInfo practitionerHiringBasicInfo = agmsHiringDalService.findPractitionerHiringBasicInfo(hiringBasicInfoId);
        //审批经纪人关系
        PractitionerHiringMemberShip practitionerHiringMemberShip = agmsHiringDalService.findPractitionerHiringMemberShip(hiringBasicInfoId);
        //审批经纪人工作经历
        List<PractitionerHiringWorkingExperience> practitionerHiringWorkingExperienceList = agmsHiringDalService.findPractitionerHiringWorkingExperienceList(hiringBasicInfoId);
        //经纪人申请名目
        List<PractitionerHiringPersonalStatements> practitionerHiringPersonalStatementsList = agmsHiringDalService.findPractitionerHiringPersonalStatementsList(hiringBasicInfoId);
        //经纪人合同条款是否同意
        List<PractitionerHiringContractTermsConfirms> practitionerHiringContractTermsConfirmsList = agmsHiringDalService.findPractitionerHiringContractTermsConfirmsList(hiringBasicInfoId);
        //已审批结果
        List<PractitionerHiringApproveRecords> practitionerHiringApproveRecordsList = agmsHiringDalService.findPractitionerHiringApproveRecordsList(hiringBasicInfoId);
        //查询是否可进行审批操作 0.不可审批(未到)  1.可审批  2.已审批  3.无权审批(默认)
        PractitionerHiringApproveSteps practitionerHiringApproveSteps = getHiringApproveStatus(loginId,practitionerHiringMemberShip.getPractitionerLevelId(),practitionerHiringApproveRecordsList);
        responseVO.setHiringBasicInfoId(hiringBasicInfoId);
        responseVO.setPractitionerHiringApproveSteps(practitionerHiringApproveSteps);
        responseVO.setPractitionerHiringBasicInfo(practitionerHiringBasicInfo);
        responseVO.setPractitionerHiringMemberShip(practitionerHiringMemberShip);
        responseVO.setPractitionerHiringWorkingExperienceList(practitionerHiringWorkingExperienceList);
        responseVO.setPractitionerHiringPersonalStatementsList(practitionerHiringPersonalStatementsList);
        responseVO.setPractitionerHiringContractTermsConfirmsList(practitionerHiringContractTermsConfirmsList);
        responseVO.setPractitionerHiringApproveRecordsList(practitionerHiringApproveRecordsList);
        responseVO.setCommonResult(new CommonResult(true, ZHBErrorConfig.getErrorInfo("800000")));
        return responseVO;
    }

    @Override
    public PractitionerHiringListResponseVO practitionerHiringList(PractitionerHiringListRequestVO requestVO) {
        PractitionerHiringListResponseVO responseVO = new PractitionerHiringListResponseVO();
        PageInfo<PractitionerHiringListInfo> pageInfo = requestVO.getPageInfo();
        PageInfo<PractitionerHiringListInfo> hiringListInfoPageInfo = agmsHiringDalService.practitionerHiringList(pageInfo);
        responseVO.setPractitionerHiringList(hiringListInfoPageInfo);
        responseVO.setCommonResult(new CommonResult(true, ZHBErrorConfig.getErrorInfo("800000")));
        return responseVO;
    }

    private PractitionerHiringApproveSteps getHiringApproveStatus(Long loginId, String practitionerLevelId, List<PractitionerHiringApproveRecords> practitionerHiringApproveRecordsList) {
        //是否可进行审批操作 0.不可审批(未到)  1.可审批  2.已审批  3.无权审批(默认) 4.已驳回
        Long hiringApproveStatus = 3L;
        //审批到哪一步了
        Long hiringApproveStepsId = null;
        //查看审批流程最后一次,是否通过
        PractitionerHiringApproveRecords recordsFinally = null;
        if (!practitionerHiringApproveRecordsList.isEmpty()) {
            recordsFinally = practitionerHiringApproveRecordsList.get(practitionerHiringApproveRecordsList.size() - 1);
            Long approvingStatusId = recordsFinally.getApprovingStatusId();
            if (CommonUtil.isNullOrZero(approvingStatusId)) {
                //已驳回
                hiringApproveStatus = 4L;
                return new PractitionerHiringApproveSteps(hiringApproveStatus, hiringApproveStepsId);
            }
        }

        //通过loginId查询对应的经纪人id
        Long loginPractitionerId = agmsHiringDalService.findPractitionerIdByLoginId(loginId);
        //AGMS登入者手机号不是经纪人手机号,无权审批
        if (!CommonUtil.isNullOrZero(loginPractitionerId)) {
            return new PractitionerHiringApproveSteps(hiringApproveStatus, hiringApproveStepsId);
        }
        //遍历已审批结果,查看此agms登入者是否已审批
        for (PractitionerHiringApproveRecords practitionerHiringApproveRecords : practitionerHiringApproveRecordsList) {
            Long approvingPractitionerId = practitionerHiringApproveRecords.getApprovingPractitionerId();
            if (approvingPractitionerId.equals(loginPractitionerId)) {
                //已审批
                hiringApproveStatus = 2L;
                return new PractitionerHiringApproveSteps(hiringApproveStatus, hiringApproveStepsId);
            }
        }
        //查询审批流程
        List<MdPractitionerHiringApproveSteps> hiringApproveSteps = systemConfigService.findHiringApproveStepsByPractitionerLevel(practitionerLevelId);
        //通过loginId查询登入者手机号码
        AclUser user = aclUserDalService.selectByPrimaryKey(loginId);
        String loginMobileNo = user.getMobileNo();
        //所有通过agms审批的手机号码
        List<String> hiringApproveMobileNo = systemConfigService.findHiringApproveMobileNo(hiringApproveSteps, practitionerLevelId);
        //agms登入者无审批权力
        if (!hiringApproveMobileNo.contains(loginMobileNo)) {
            return new PractitionerHiringApproveSteps(hiringApproveStatus, hiringApproveStepsId);
        }
        //此经纪人最后一次审批步骤id
        hiringApproveStepsId = recordsFinally.getApproveStepId();
        //查询此经纪人最后一次审批步骤详细信息
        int seq = 0;
        for (int i = 0; i < hiringApproveSteps.size(); i++) {
            Long id = hiringApproveSteps.get(i).getId();
            if (id.equals(hiringApproveStepsId)) {
                seq = i;
                break;
            }
        }
        MdPractitionerHiringApproveSteps mdPractitionerHiringApproveSteps = hiringApproveSteps.get(seq);
        //通过手机号码查询此agmd登入者拥有哪些审批步骤(肯定有值)
        List<MdPractitionerHiringApproveSteps> hiringApproves = mdPractitionerHiringApproveStepsDalService.findByAppointedApprovePractitioners(loginMobileNo);
        //最后一个审批步骤的seq
        Integer stepSeq = mdPractitionerHiringApproveSteps.getStepSeq();
        MdPractitionerHiringApproveSteps loginHiringApproveStep = null;
        for (MdPractitionerHiringApproveSteps hiringApprove : hiringApproves) {
            Integer loginStepSeq = hiringApprove.getStepSeq();
            if (stepSeq < loginStepSeq) {
                loginHiringApproveStep = hiringApprove;
                break;
            }
        }
        if (loginHiringApproveStep == null){
            hiringApproveStatus = 2L;
            return new PractitionerHiringApproveSteps(hiringApproveStatus, hiringApproveStepsId);
        }
        //查看下一审批步骤
        mdPractitionerHiringApproveSteps = hiringApproveSteps.get(seq+1);
        Long mdPractitionerHiringApproveStepsId = mdPractitionerHiringApproveSteps.getId();
        Long loginHiringApproveStepId = loginHiringApproveStep.getId();
        if (mdPractitionerHiringApproveStepsId.equals(loginHiringApproveStepId)){
            //可审批
            hiringApproveStatus = 1L;
            hiringApproveStepsId = mdPractitionerHiringApproveStepsId;
        }else {
            //0.不可审批(未到)
            hiringApproveStatus = 0L;
        }
        return new PractitionerHiringApproveSteps(hiringApproveStatus, hiringApproveStepsId);
    }
}
