package com.yd.api.agms.service;

import com.yd.api.agms.vo.practitioner.*;
import com.yd.api.result.CommonResultResponseVO;

import javax.servlet.http.HttpServletResponse;

/**
 * @author xxy
 */
public interface AgmsPractitionerService {
    /**
     * AGMS -- 经纪人保存文章
     * @param requestVO 请求数据
     * @return 响应数据
     */
    PractitionerFileSharingSaveResponseVO practitionerFileSharingSave(PractitionerFileSharingSaveRequestVO requestVO);

    /**
     * AGMS -- 经纪人查询文章
     * @param requestVO 请求数据
     * @return 响应数据
     */
    PractitionerFileSharingListResponseVO practitionerFileSharingList(PractitionerFileSharingListRequestVO requestVO);

    /**
     * 经纪人日程管理
     * @param requestVO
     * @return
     */
    PractitionerScheduleResponseVO practitionerSchedule(PractitionerScheduleRequestVO requestVO);

    CommonResultResponseVO practitionerScheduleExport(PractitionerScheduleRequestVO requestVO, HttpServletResponse response);

    PractitionerLeadsGoalsResponseVO practitionerLeadsGoals(PractitionerLeadsGoalsRequestVO requestVO);

    CommonResultResponseVO practitionerLeadsGoalsExport(PractitionerLeadsGoalsRequestVO requestVO, HttpServletResponse response);

    PractitionerActivityResponseVO practitionerActivity(PractitionerActivityRequestVO requestVO);

    CommonResultResponseVO practitionerActivityExport(PractitionerActivityRequestVO requestVO, HttpServletResponse response);
}
