package com.yd.dal.entity.customer;

import lombok.Data;

import java.util.Date;

/**
 * 从业人员执业证信息表
 */
@Data
public class AclPractitioner {
    private static final long serialVersionUID = 1L;
    /**
     * serial id
     */
    private Long id;

    /**
     * FK ag_acl_insurer.id
     */
    private Long insurerId;

    /**
     * FK ag_acl_insurer_branch.id
     */
    private Long insurerBranchId;

    /**
     * FK ag_acl_insurer_branch_dept.id 所属部门id
     */
    private Long deptId;

    /**
     * FK ag_acl_practitioner_subordinate_system.id 所属部门id
     */
    private Long subordinateSystemId;

    /**
     * 从业人员编号
     */
    private String practitionerCode;

    /**
     * 从业人员姓名
     */
    private String name;

    /**
     * 从业人员电话
     */
    private String mobileNo;

    /**
     * FK ag_md_id_type.id
     */
    private Long idTypeId;

    /**
     * 从业人员证件类型
     */
    private String idType;

    /**
     * 从业人员证件号
     */
    private String idNo;

    /**
     * 从业人员生日
     */
    private Date practitionerBirthdate;

    /**
     * 从业人员执业证编号
     */
    private String practitionerRegNo;

    /**
     * 从业人员所属公司
     */
    private String practitionerRegCompany;

    /**
     * 有效起日
     */
    private Date effectiveStartDate;

    /**
     * 有效终日
     */
    private Date effectiveEndDate;

    /**
     * 备注
     */
    private String remark;

    /**
     * FK ag_acl_customer.id
     */
    private Long customerId;

    /**
     * 公司员工编码
     */
    private String employeeNo;

    /**
     * 员工合同编号
     */
    private String contractNo;

    /**
     * 0=No, 1=Yes
     */
    private Integer isActive;

    /**
     * 建置日
     */
    private Date createdAt;

    /**
     * 建置者
     */
    private Long createdBy;

    /**
     * 更新日
     */
    private Date updatedAt;

    private Long updatedBy;

    /**
     * 从业人员所属区域-省份 FK ag_md_province.id
     */
    private Long provinceId;

    /**
     * 所属区域省份名
     */
    private String provinceName;

    /**
     * 从业人员所属区域-城市 FK ag_md_city.id
     */
    private Long cityId;

    /**
     * 所属区域城市名
     */
    private String cityName;

    /**
     * 政治面貌
     */
    private String politicalOutlook;

    /**
     * 从业人员证照/荣誉列 FK ag_md_certificate.id
     */
    private String certList;

    /**
     * 从业人员自我简介
     */
    private String bioIntro;

    /**
     * 从业人员自我简介(经纪人自己设置的)
     */
    private String bioIntroTwo;

    /**
     * 从业人员微信号
     */
    private String wechatId;

    /**
     * 从业人员QQ号
     */
    private String qqId;

    /**
     * 查询是否显示 0=No=不显示 1=Yes=显示
     */
    private Integer isProfileShow;

    /**
     * 姓名是否显示 0=No=不显示 1=Yes=显示
     */
    private Integer isNameShow;

    /**
     * 电话是否显示 0=No=不显示 1=Yes=显示
     */
    private Integer isMobileShow;

    /**
     * 教育程度
     */
    private String educationLevel;

    /**
     * 毕业学校
     */
    private String graduatedUniversity;

    /**
     * FK ag_acl_practitioner.id 辅导人
     */
    private Long mentorId;

    /**
     * FK ag_acl_practitioner.id 间接辅导人
     */
    private Long inMentorId;

    /**
     * FK ag_acl_practitioner.id 介绍人
     */
    private Long introducerId;

    /**
     * 1=Male, 2=Female
     */
    private Integer gender;

    /**
     * 经纪人通过最后一步审批后生成的电子合同
     */
    private String contractOssPath;

    /**
     * FK ag_acl_practitioner_hiring_basic_info.id
     */
    private Long hiringBasicInfoId;

    /**
     * 能够登录dyd
     */
    private Long canLoginDyd;

    /**
     * 能够查看薪资表
     */
    private Long canSeeSalaryList;

    /**
     * 能够查看银盾学院
     */
    private String canSeeYdCollege;

    /**
     * cffp角色代码,通过,分割
     */
    private String cffpRoleCode;

    /**
     * 详细地址
     */
    private String detailAddress;

    /**
     * 开户银行
     */
    private String accountBank;
    /**
     * 银行卡号
     */
    private String bankCardNo;
    /**
     * 电子邮件
     */
    private String email;
    /**
     * 经纪人邮箱是否开通(0=No, 1=Yes)
     */
    private Integer emailIsActive;

    /**
     * 育成人id
     */
    private Long raiseId;

    private Long s1Id;
    private Long s2Id;
    private Long s3Id;
}
