package com.yd.dal.service.practitioner;

import com.github.pagehelper.PageInfo;
import com.yd.api.practitioner.vo.hiring.PractitionerHiringContractTerms;
import com.yd.dal.entity.agms.hiring.*;
import com.yd.dal.entity.practitioner.hiring.*;

import java.util.List;

/**
 * @author xxy
 */
public interface PractitionerHiringDALService {
    /**
     * 通过经纪人id查询此人审批的报聘经纪人
     *
     * @param practitionerId 经纪人id
     * @return 返回结果
     */
    List<HiringListInfo> findHiringList(Long practitionerId);

    /**
     * 经纪人审批基本信息
     *
     * @param hiringBasicInfoId 经纪人基本信息id  ag_acl_practitioner_hiring_basic_info.id
     * @return 查询结果
     */
    HiringBasicInfo findHiringBasicInfo(Long hiringBasicInfoId);

    /**
     * 审批经纪人关系
     *
     * @param hiringBasicInfoId 经纪人基本信息id  ag_acl_practitioner_hiring_basic_info.id
     * @return 查询结果
     */
    HiringMemberShip findHiringMemberShip(Long hiringBasicInfoId);

    /**
     * 审批经纪人工作经历
     *
     * @param hiringBasicInfoId 经纪人基本信息id  ag_acl_practitioner_hiring_basic_info.id
     * @return 查询结果
     */
    List<HiringWorkingExperience> findHiringWorkingExperienceList(Long hiringBasicInfoId);

    /**
     * 经纪人申请名目
     *
     * @param hiringBasicInfoId 经纪人基本信息id  ag_acl_practitioner_hiring_basic_info.id
     * @return 查询结果
     */
    List<HiringPersonalStatements> findHiringPersonalStatementsList(Long hiringBasicInfoId);

    /**
     * 经纪人合同条款是否同意
     *
     * @param hiringBasicInfoId 经纪人基本信息id  ag_acl_practitioner_hiring_basic_info.id
     * @return 查询结果
     */
    List<HiringContractTermsConfirms> findHiringContractTermsConfirmsList(Long hiringBasicInfoId);

    /**
     * 已审批结果
     *
     * @param hiringBasicInfoId 经纪人基本信息id  ag_acl_practitioner_hiring_basic_info.id
     * @return 查询结果
     */
    List<HiringApproveRecords> findHiringApproveRecordsList(Long hiringBasicInfoId);

    /**
     * 查询经纪人报聘的所有合同
     * @return
     */
    List<PractitionerHiringContractTerms> queryContractTerms();

}
