package com.yd.rmi.tencent.wechat;

import com.yd.api.result.JsonResult;
import com.yd.rmi.cache.SystemConfigService;
import com.yd.rmi.tencent.wechat.service.WechatService;
import com.yd.rmi.tencent.wechatinterf.pojo.ticket.TicketRequest;
import com.yd.rmi.tencent.wechatinterf.pojo.token.TokenRequest;
import com.yd.rmi.tencent.wechatinterf.pojo.wechatpay.WxConfigRequestVO;
import com.yd.rmi.tencent.wechatinterf.pojo.wechatpay.WxConfigResponseVO;
import com.yd.util.SpringContextUtil;
import com.yd.util.config.ZHBErrorConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Map;

@Controller
@CrossOrigin(origins = "*")
public class WechatController {
	@Autowired
	private WechatService wechatService;
	@Autowired
	private SystemConfigService systemConfigService;
	/**
	 * 微信分享时授权
	 * @param wxConfigRequestVO
	 * @return
	 */
	@RequestMapping("/wxConfig")
	@ResponseBody
	public Object wxConfig(@RequestBody WxConfigRequestVO wxConfigRequestVO){
		String accessToken = wechatService.obtainToken(new TokenRequest());
		TicketRequest ticketRequest = new TicketRequest();
		ticketRequest.setAccessToken(accessToken);
		String jsapiTicket = wechatService.obtainTicket(ticketRequest);
		String url = wxConfigRequestVO.getUrl();
		try {url = URLDecoder.decode(wxConfigRequestVO.getUrl(), "utf-8");} catch (UnsupportedEncodingException e) {}
		Map<String, String> ret = wechatService.jsapiTicketSign(jsapiTicket,url);
		JsonResult result = new JsonResult();
		WxConfigResponseVO wxConfigResponseVO = new WxConfigResponseVO();
		if(SpringContextUtil.isProd()){
			wxConfigResponseVO.setAppId(systemConfigService.getSingleConfigValue("YD-TENCENT_WECHAT_APPID"));
		}else {
			wxConfigResponseVO.setAppId(systemConfigService.getSingleConfigValue("TENCENT_WECHAT_APPID"));
		}
		wxConfigResponseVO.setTimestamp(ret.get("timestamp"));
		wxConfigResponseVO.setNonceStr(ret.get("nonceStr"));
		wxConfigResponseVO.setSignature(ret.get("signature"));
		wxConfigResponseVO.setJsApiList(new String[]{"updateAppMessageShareData","updateTimelineShareData","onMenuShareTimeline","onMenuShareAppMessage","onMenuShareQQ","onMenuShareWeibo","onMenuShareQZone","chooseImage","uploadImage","downloadImage","getLocalImgData"});
		result.setData(wxConfigResponseVO);
		result.setSuccess(true);
		result.setMessage(ZHBErrorConfig.getErrorInfo("800000"));
		return result;
	}
}
