package com.yd.api.practitioner.service;

import com.yd.api.practitioner.vo.recruit.PotentialGoalsActionsUpdateResponseVO;
import com.yd.api.practitioner.vo.recruit.PotentialGoalsQueryResponseVO;
import com.yd.api.practitioner.vo.login.PractitionerLoginRequestVO;
import com.yd.api.practitioner.vo.login.PractitionerLoginResponseVO;
import com.yd.api.practitioner.vo.media.MediaGetReqVO;
import com.yd.api.practitioner.vo.media.MediaGetRespVO;
import com.yd.api.practitioner.vo.opportunity.*;
import com.yd.api.practitioner.vo.rank.PractitionerRankRequestVO;
import com.yd.api.practitioner.vo.rank.PractitionerRankResponseVO;
import com.yd.api.practitioner.vo.recruit.*;
import com.yd.api.practitioner.vo.setting.*;
import org.springframework.stereotype.Service;

@Service("practitionerService")
public interface PractitionerService {

    /**
     * 经纪人登录接口
     * @param requestVO 请求信息
     * @return PractitionerLoginResponseVO
     */
    PractitionerLoginResponseVO practitionerLogin(PractitionerLoginRequestVO requestVO);

    /**
     * 经纪人排行榜查询
     * @param requestVO 请求信息
     * @return PractitionerRankResponseVO
     */
    PractitionerRankResponseVO practitionerRank(PractitionerRankRequestVO requestVO);

    /**
     * 经纪人设置查询
     * @param requestVO
     * @return
     */
    SettingQueryResponseVO settingQuery(SettingQueryRequestVO requestVO);

    /**
     * 经纪人删除头像生活照
     * @param requestVO
     * @return
     */
    ImgDeleteResponseVO imgDelete(ImgDeleteRequestVO requestVO);

    /**
     * 保存经纪人设置头像,生活照
     * @param requestVO
     * @return
     */
    SettingSaveResponseVO settingSave(SettingSaveRequestVO requestVO) throws Exception;

    /**
     * 微信上传图片
     * @param requestVO
     * @return
     */
    MediaGetRespVO mediaGet(MediaGetReqVO requestVO);

    /**
     * 经纪人查询自己的商机
     * @param requestVO
     * @return
     */
    OwnOpportunityQueryResponseVO ownOpportunityQuery(OwnOpportunityQueryRequestVO requestVO);

    /**
     * 经纪人查询自己的商机详情查询
     * @param requestVO
     * @return
     */
    OwnOpportunityDetailQueryResponseVO ownOpportunityDetailQuery(OwnOpportunityDetailQueryRequestVO requestVO);
    /**
     * 团队长--增员
     * @param requestVO 请求信息
     * @return responseVO
     */
    RecruitResponseVO recruit(RecruitRequestVO requestVO);
    /**
     * 团队长--新增增员记录
     * @param requestVO 请求信息
     * @return responseVO
     */
    AddRecruitTrackResponseVO addRecruitTrack(AddRecruitTrackRequestVO requestVO);

    /**
     * 团队长--增员记录查询
     * @param requestVO 请求信息
     * @return responseVO
     */
    RecruitTrackQueryResponseVO recruitTrackQuery(RecruitTrackQueryRequestVO requestVO);

    /**
     * 团队长--增员列表查询
     * @param requestVO 请求信息
     * @return responseVO
     */
    RecruitListResponseVO recruitListQuery(RecruitListRequestVO requestVO);

    /**
     * 修改商机基本信息
     * @param requestVO
     * @return
     */
    OwnOpportunityBasicInformationSaveResponseVO ownOpportunityBasicInformationSave(OwnOpportunityBasicInformationSaveRequestVO requestVO);

    /**
     * 保存商机跟进,修改商机基本信息
     * @param requestVO
     * @return
     */
    OwnOpportunityRecordSaveResponseVO ownOpportunityRecordSave(OwnOpportunityRecordSaveRequestVO requestVO);

    /**
     * 保存增员目标
     * @param requestVO 请求数据
     * @return 响应数据
     */
    PotentialGoalsSettingResponseVO potentialGoalsSetting(PotentialGoalsSettingRequestVO requestVO);

    /**
     * 查询增员目标
     * @param requestVO 请求数据
     * @return 响应数据
     */
    PotentialGoalsQueryResponseVO potentialGoalsQuery(PotentialGoalsQueryRequestVO requestVO);
    /**
     * 查询增员目标活动量
     * @param requestVO 请求数据
     * @return 响应数据
     */
    PotentialGoalsActionsQueryResponseVO potentialGoalsActionsQuery(PotentialGoalsActionsQueryRequestVO requestVO);

    /**
     * 团队长--更新增员目标活动量
     * @param requestVO 请求数据
     * @return 响应数据
     */
    PotentialGoalsActionsUpdateResponseVO potentialGoalsActionsUpdate(PotentialGoalsActionsUpdateRequestVO requestVO);

    /**
     * 团队长--查看目前自己的活动量
     * @param requestVO 请求数据
     * @return 响应数据
     */
    PotentialActivityQueryResponseVO potentialActivityQuery(PotentialActivityQueryRequestVO requestVO);
}
