package com.yd.dal.entity.marketing;

import java.util.Date;
import lombok.Data;

/**
    * 经纪人商机增员目标分摊计算公式
    */
@Data
public class MktGoalsCalculateExpression {
    /**
    * serial id
    */
    private Long id;

    /**
    * 目标所属年度
    */
    private Integer currentYear;

    /**
    * FK ag_md_drop_master.id 商机销售行动drop_master id = 14 or 经纪人增员活动16
    */
    private Integer dropMasterId;

    /**
    * FK ag_md_drop_options.id 商机销售行动drop_master id = 14 or 16
    */
    private Integer actionId;

    /**
    * javascript计算公式，参数：成交件数，
成交件数a
建议书数量b = a * 3
见面沟通次数c = a * 3
电话/微信沟通次数d = a * 9
安排见面次数f = a * 27
获取商机次数g = a * 27

报聘（a)= 年目标增员对象/12
报聘面谈 b = a
OPP创说会 c = a * 3
甄选面谈 d = a * 3
增员面谈 e =  a * 9
建立名单 f =  a * 9

    */
    private String calculateScriptExpression;

    /**
    * 创建时间
    */
    private Date createdAt;

    /**
    * 创建人
    */
    private Long createdBy;

    /**
    * 修改时间
    */
    private Date updatedAt;

    private Long updatedBy;
}