package com.yd.dal.entity.marketing;

import java.util.Date;
import lombok.Data;

/**
    * 经纪人商机目标设定
    */
@Data
public class MktLeadsGoals {
    /**
    * serial id
    */
    private Long id;

    /**
    * FK ag_acl_practitioner.id 经纪人
    */
    private String practitionerId;

    /**
    * 目标所属年度
    */
    private Integer currentYear;

    /**
    * 1：年度，3：月度
    */
    private Integer statisticTimeUnit;

    /**
    * 保费
    */
    private Integer premium;

    /**
    * 佣金
    */
    private Integer commission;

    /**
    * 件数
    */
    private Integer pieces;

    /**
    * 件均保费： 计算生成  FYP/件数
    */
    private Integer pieceAveragePremium;

    /**
    * 版本控制
    */
    private Date currentVersion;

    /**
    * 创建时间
    */
    private Date createdAt;

    /**
    * 创建人
    */
    private Long createdBy;

    /**
    * 修改时间
    */
    private Date updatedAt;

    private Long updatedBy;
}