package com.yd.api.commission;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.yd.api.commission.service.CommissionService;

@Controller
@RestController
public class CommissionController {
	
	@Autowired
	private CommissionService commissionService;
	/**
	 * 按照手机号从AGMS DB中查询佣金
	 * @param login
	 * @return
	 */
	@RequestMapping("/queryCommissionByLogin")
	public Object queryCommissionByLogin(@RequestBody String login){
		
		return commissionService.queryCommissionByLogin(login);
	}
	
	/**
	 * 按照手机号从EGolden DB中查询佣金
	 * @param login
	 * @return
	 */
	@RequestMapping("/queryCommissionByLoginFromEGolden")
	public Object listAllUserfromEGolden(@RequestBody String login){
		
		return commissionService.listSalesCommissionfromEGolden(login);
	}
}