package com.yd.api.practitioner.service.impl;

import com.yd.api.practitioner.vo.rank.AclCustomerFortuneStatistics;
import com.yd.api.practitioner.vo.rank.PractitionerRankRequestVO;
import com.yd.api.practitioner.vo.rank.PractitionerRankResponseVO;
import com.yd.api.practitioner.vo.rank.PractitionerInfoForAchievement;
import com.yd.api.result.CommonResult;
import com.yd.dal.entity.practitioner.PractitionerBasicInfo;
import com.yd.dal.entity.practitioner.PractitionerRankInfo;
import com.yd.dal.service.practitioner.PractitionerServiceDAL;
import com.yd.util.config.ZHBErrorConfig;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.google.common.base.Strings;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

@Service("practitionerService")
public class PractitionerServiceImpl implements com.yd.api.practitioner.service.PractitionerService {

    @Autowired
    private PractitionerServiceDAL practitionerServiceDAL;
    @Override
    public PractitionerRankResponseVO practitionerRank(PractitionerRankRequestVO requestVO) {
        PractitionerRankResponseVO responseVO = new PractitionerRankResponseVO();
        String mobileNo = requestVO.getMobileNo();
        Integer type = requestVO.getType();
        Integer time = requestVO.getTime();
        Integer platform = requestVO.getPlatform();
        type = (type == null) ? 1 : type;//默认：保费
        time = (time == null) ? 1 : time;//默认：本月
        platform = (platform == null) ? 1 : platform;
        if(!Strings.isNullOrEmpty(mobileNo)){
            //查询该手机号码的经纪人id，是否存在
            PractitionerBasicInfo practitionerBasicInfo = getPractitionerBasicInfo(mobileNo,platform);
            if(practitionerBasicInfo != null){
                String practitionerId = practitionerBasicInfo.getPractitionerId();
                if(!Strings.isNullOrEmpty(practitionerId)){
                    List<PractitionerRankInfo> rankInfoList = getPractitionerRankInfo(time,platform);
                    //按照指定类型排序
                    getPractitionerRankResult(responseVO,rankInfoList,type,practitionerId);
                    responseVO.setCommonResult(new CommonResult(true, ZHBErrorConfig.getErrorInfo("800000")));
                }
            }else{
                responseVO.setCommonResult(new CommonResult(false, ZHBErrorConfig.getErrorInfo("820001"))); //该经纪人不存在
            }
        }else{
            String [] param = {"mobileNo"};
            responseVO.setCommonResult(new CommonResult(false, ZHBErrorConfig.getErrorInfo("610001", param)));
        }
        return responseVO;
    }

    private List<PractitionerRankInfo> getPractitionerRankInfo(Integer time, Integer platform) {
        List<PractitionerRankInfo> rankInfoList;
        if(platform == 1){
            rankInfoList = practitionerServiceDAL.getPractitionerRankInfoForOnline(time);
        }else{
            rankInfoList = practitionerServiceDAL.getPractitionerRankInfoForOffline(time);
        }
        return rankInfoList;
    }

    private PractitionerBasicInfo getPractitionerBasicInfo(String mobileNo, Integer platform) {
        PractitionerBasicInfo practitionerBasicInfo;
        if(platform == 1){
            practitionerBasicInfo = practitionerServiceDAL.getPractitionerBasicInfoForOnline(mobileNo);
            if(practitionerBasicInfo != null){
                Long practitionerId = practitionerBasicInfo.getPractitionerIdForOnline();
                if(practitionerId != null){
                    practitionerBasicInfo.setPractitionerId(practitionerId.toString());
                }
            }
        }else{
            practitionerBasicInfo = practitionerServiceDAL.getPractitionerBasicInfoForOffline(mobileNo);
        }
        return practitionerBasicInfo;
    }

    private void getPractitionerRankResult(PractitionerRankResponseVO responseVO, List<PractitionerRankInfo> rankInfoList, Integer type, String practitionerId) {
        PractitionerInfoForAchievement practitionerInfo = new PractitionerInfoForAchievement();
        List<AclCustomerFortuneStatistics> rankList = new ArrayList<>();
        if(!rankInfoList.isEmpty()){
            //1-保费，2-佣金，3-件数
            if(2 == type){
                rankInfoList.sort(Comparator.comparingDouble(PractitionerRankInfo::getFyc).reversed());
            }else if(3 == type){
                rankInfoList.sort(Comparator.comparingInt(PractitionerRankInfo::getCount).reversed());
            }else{
                rankInfoList.sort(Comparator.comparingDouble(PractitionerRankInfo::getFyp).reversed());
            }
            AclCustomerFortuneStatistics fortuneStatistics;
            int rank = 1;
            boolean rank10 ,getSelf = false;
            for(PractitionerRankInfo practitionerItem : rankInfoList){
                Long practitionerIdForOnLine = practitionerItem.getPractitionerIdForOnLine();
                if(practitionerIdForOnLine != null){
                    practitionerItem.setPractitionerId(practitionerIdForOnLine.toString());
                }
                rank10 = (rank > 10);
                if(!rank10){
                    fortuneStatistics = new AclCustomerFortuneStatistics();
                    BeanUtils.copyProperties(practitionerItem,fortuneStatistics);
                    fortuneStatistics.setSubordinateSystemName(practitionerItem.getSpcDivName());
                    fortuneStatistics.setRank(rank);
                    rankList.add(fortuneStatistics);
                }
                if(!getSelf){
                    String practitionerIdItem = practitionerItem.getPractitionerId();
                    if(practitionerId.equals(practitionerIdItem)){
                        BeanUtils.copyProperties(practitionerItem,practitionerInfo);
                        practitionerInfo.setRank(rank);
                        getSelf = true;
                    }
                }
                if(rank10 && getSelf){
                    break;
                }
                rank ++;
            }
            if(!getSelf){
                practitionerInfo.setCount(0);
                practitionerInfo.setFyc(0D);
                practitionerInfo.setFyp(0D);
            }
        }else{
            practitionerInfo.setCount(0);
            practitionerInfo.setFyc(0D);
            practitionerInfo.setFyp(0D);
        }
        responseVO.setPractitionerInfo(practitionerInfo);
        responseVO.setRank(rankList);
    }
}
