package com.yd.util.deshandler;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;

import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;

import com.yd.util.DESUtils;

public class DESTypeHandler extends BaseTypeHandler<Object> {

	private static final String secret_property_key = "encryption.key";
	private static final String secret_property_enabled_key = "encryption.enabled";
	private static final Properties properties = new Properties();
	private static String sensitivekey = null;
	private static Boolean sensitiveenabled = false;

	static {
		try {
			properties.load(DESTypeHandler.class.getClassLoader()
					.getResourceAsStream("persistence.properties"));
		} catch (Exception e) {
			properties.put(secret_property_key, "12345678");
			properties.put(secret_property_enabled_key, "false");
		}
	}
	
	@Override
	public void setNonNullParameter(PreparedStatement ps, int i, Object parameter, JdbcType jdbcType)
			throws SQLException {
		if (parameter == null)
		{
			return;
		}
		
		String result = null;
		
		if (parameter != null)
		{
			result = encode((String)parameter);
		}
		
		ps.setString(i, result);
	}

	@Override
	public Object getNullableResult(ResultSet rs, String columnName) throws SQLException {
		String columnValue = rs.getString(columnName);
		
		String result = decode(columnValue);
		return result;
	}

	@Override
	public Object getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
		String columnValue = rs.getString(columnIndex);
		
		String result = decode(columnValue);
		return result;		
	}
	
	@Override
	public String getNullableResult(CallableStatement cs, int columnIndex)
			throws SQLException {
		String columnValue = cs.getString(columnIndex);
		
		String result = decode(columnValue);
		return result;		
	}
	/**
	 * 解密
	 * @param context
	 * @return
	 * @throws SQLException
	 */
	public String encode(String context) throws SQLException {
		sensitiveenabled = Boolean.valueOf(properties.get(secret_property_enabled_key).toString());
		if (sensitiveenabled==false)
		{
			return null;
		}
		
		sensitivekey = (String)properties.get(secret_property_key);
		DESUtils des;
		String result = null;
		try {
			des = new DESUtils(sensitivekey, "utf-8");
			if (context != null)
			{
				result = des.encode((String)context);
			}
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		return result;
	}
	/**
	 * 解密
	 * @param columnValue
	 * @return
	 */
	public String decode(String encrypted) {
		sensitiveenabled = Boolean.valueOf(properties.get(secret_property_enabled_key).toString());
		if (sensitiveenabled==false)
		{
			return encrypted;
		}
		if (encrypted == null)
		{
			return null;
		}
		sensitivekey = (String)properties.get(secret_property_key);
		DESUtils des;
		String result = null;
		try {
			des = new DESUtils(sensitivekey, "utf-8");
			if (encrypted != null)
			{
				result = des.decode(encrypted);
			}
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		return result;
	}

}

