import { fileURLToPath, URL } from 'node:url'
import { defineConfig } from 'vite'
import vue from '@vitejs/plugin-vue'
import vueJsx from '@vitejs/plugin-vue-jsx'
import vueDevTools from 'vite-plugin-vue-devtools'
import { resolve } from 'path'

export default defineConfig({
  // 关键配置：设置基础路径为子目录 yd-email
  base: process.env.NODE_ENV === 'production' ? '/yd-email/' : '/yd-email/',
  plugins: [vue(), vueJsx(), vueDevTools()],
  resolve: {
    alias: {
      '@': fileURLToPath(new URL('./src', import.meta.url)),
      '@/components': resolve(__dirname, 'src/components'),
    },
  },
  // 添加CSS配置
  css: {
    postcss: './postcss.config.js',
  },
  server: {
    port: 5173,
    host: 'localhost',
    open: true,
    proxy: {
      'email/api': {
        target: 'http://139.224.145.34:9002',
        changeOrigin: true,
        rewrite: (path) => path.replace(/^\/email\/api/, ''),
      },
    },
  },
})
