// 分页类型
export interface Pagination<T> {
  records?: T[]
  total?: number
  pageSize?: number
  sortField?: string
  sortOrder?: string
  pageNo?: number
}

// 联系人类型
export interface Contact<T> extends Pagination<Contact> {
  contactBizId?: string
  name?: string
  type?: string
  companyName?: string
  email?: string
  ccEmailList?: string[]
  other?: string
  appellation?: string
}

// 发件人类型
export interface Sender extends Pagination<Sender> {
  senderBizId?: string
  email?: string
  password?: string
  displayName?: string
  providerBizId?: string
  active?: number
  emailSenderConfigName?: string
  emailSenderConfigEmail?: string
}

// 变量类型
export interface Variable extends Pagination<Variable> {
  id?: string
  variableBizId?: string
  variableNameCn?: string
  variableNameEn?: string
  description?: string
  isGeneral?: number
}

// 变量模板类型
export interface VariableTemplate extends Pagination<VariableTemplate> {
  variableGroupBizId?: string
  groupName?: string
  description?: string
  variableBizIdList?: string[]
  variableNameEns?: string[]
  variableNameEnList?: string[]
}

// 忘记密码表单类型
export interface ForgotPasswordForm {
  email: string
  newPassword: string
  confirmPassword: string
}

// 导入记录类型
export interface ImportRecord extends Contact<ImportRecord> {
  sessionId?: string
  receiveEmailList?: string[]
  ccEmailList?: string[]
  ccEmail?: string
}

// 选择联系人时，调用接口，获取sessionId
export interface ContactSessionId {
  sessionId?: string
  apiEmailContactDtoList?: Contact<unknown>[]
}

// 编辑-邮件联系人导入信息
export interface EditContactImport extends Pagination<EditContactImport> {
  receiveEmail?: string
  sessionId?: string
  source?: string
}
// 发送邮件
export interface SendEmail {
  senderBizId?: string
  sendEmail?: string
  subject?: string
  content?: string
  scheduleTime?: string
  attachmentPath?: string
  variableGroupBizId?: string
  sessionId?: string
  recipientEmailList?: string[]
  ccEmailList?: string[]
  bccEmailList?: string[]
  receiveEmailList?: string[]
}

export interface EmailForm {
  senderBizId?: string
  sendEmail?: string
  variableGroupBizId?: string
  receiveEmail?: string
  ccEmailList?: string[]
  subject?: string
  content?: string
  attachmentPath?: string
  sessionId?: string
  ccEmails?: string
  scheduleSend?: boolean
  scheduleTime?: string
}
//邮件服务商类型
export interface EmailProvider extends Pagination<EmailProvider> {
  providerBizId?: string
  providerName?: string
  smtpHost?: string
  smtpPort?: string
  sslEnabled?: number
  active?: number
  description?: string
}
// 发送任务列表查询参数
export interface SubTask extends Pagination<SubTask> {
  taskBizId?: string
  receiveEmail?: string
  status?: string
}
// 主线任务列表查询参数
export interface EmailTask extends Pagination<EmailTask> {
  queryContent?: string
  status?: string
  taskBizId?: string
  taskName?: string
  senderBizId?: string
  sendEmail?: string
  receiveEmails?: string
  subject?: string
  scheduleTime?: string
  sendTime?: string
  statusLabel?: string
}
// 上传参数类型
export interface UploadParams {
  file: File
  directory?: string // 上传目录
  fileName?: string // 自定义文件名
  onProgress?: (progress: number) => void // 进度回调
  additionalData?: Record<string, any> // 额外的表单数据
}

// 上传结果类型（根据后端返回格式调整）
export interface UploadResult {
  code?: number
  msg?: string
  data?: {
    url: string // 文件访问URL
    name: string // 文件名
    fileSize: number // 文件大小
    fileType: string // 文件类型
    fileKey: string // 文件唯一标识
    originalName: string // 原始文件名
    uploadTime: string // 上传时间
    accessUrl: string // 文件访问URL
    [key: string]: any // 其他可能返回的字段
  }
}

// 上传错误类型
export interface UploadError {
  code: string | number
  msg: string
  data?: any
}

// 后端接口响应标准格式
export interface ApiResponse<T = any> {
  code: number
  msg: string
  data?: T
}

// 字典表项接口
export interface DictItem {
  id?: number //字典项表主键id
  dictItemBizId?: string //字典数据id（业务id）
  dictBizId?: string //字典ID（字典类型表id）（业务id）
  itemLabel?: string //字典项标签（名称）
  itemValue?: string //字典项值（值）
  isDefault?: number //是否默认(0:否 1:是)
  orderNum?: number //排序
  status?: number //状态(0:停用 1:启用)
}
