// 联系人类型
export interface Contact {
  id: string
  name: string
  type: string
  companyName: string
  email: string
  ccEmailList: string[]
  other: string
  appellation: string
}

// 发件人类型
export interface Sender {
  id: string
  email: string
  password: string
  smtpServer: string
  smtpPort: string
}

// 变量类型
export interface Variable {
  id?: string
  variableBizId?: string
  variableNameCn?: string
  variableNameEn?: string
  description?: string
}

// 变量模板类型
export interface VariableTemplate {
  id: string
  groupName?: string
  description?: string
  variableBizIdList?: string[]
}

// 邮件类型
export interface Email {
  id: string
  sender: string
  to: string
  cc: string
  subject: string
  content: string
  sendTime: string
  status: 'sent' | 'scheduled' | 'draft' | 'failed'
  attachments?: { name: string }[]
}

// 邮件表单类型
export interface EmailForm {
  to: string
  cc: string
  subject: string
  content: string
  scheduleSend: boolean
  sendTime: string
}

// 忘记密码表单类型
export interface ForgotPasswordForm {
  email: string
  newPassword: string
  confirmPassword: string
}

// 导入记录类型
export interface ImportRecord {
  id: string
  to: string
  cc: string
  createdAt: string
  updatedAt: string
}
