import axios, { AxiosError } from 'axios'

// 创建axios实例
const request = axios.create({
  baseURL: import.meta.env.VITE_API_BASE_URL || '/api',
  timeout: 10000,
  headers: {
    'Content-Type': 'application/json',
    // Authorization: 'Bearer ' + localStorage.getItem('authToken'),
    Authorization:
      'Bearer eyJhbGciOiJIUzUxMiJ9.eyJzdWIiOiJ1c2VyXzEwMDEiLCJyb2xlcyI6W10sImlhdCI6MTc1ODY5OTA3NywiZXhwIjoxNzU4Nzg1NDc3fQ.LR2fGy0aO6EHsHe9Que8rzCaJ0TSAB9KtJndYMSYvvKOSeNvGawCmjE8kgDeRmyFFOFJ2kt0sk-fGaExgzQHSw',
  },
})

// 请求拦截器 - 添加Authorization头
request.interceptors.request.use(
  (config) => {
    // 从本地存储获取token
    const token = localStorage.getItem('authToken')

    // 如果token存在，添加到请求头
    if (token && config.headers) {
      config.headers.Authorization = `Bearer ${token}`
    }

    return config
  },
  (error: AxiosError) => {
    // 处理请求错误
    return Promise.reject(error)
  },
)

// 响应拦截器 - 处理常见错误
request.interceptors.response.use(
  (response) => {
    // 直接返回响应数据
    return response.data
  },
  (error: AxiosError) => {
    // 处理401未授权错误
    if (error.response && error.response.status === 401) {
      // 清除无效token
      localStorage.removeItem('authToken')

      // 如果不是登录页面，跳转到登录页
      if (!window.location.pathname.includes('/login')) {
        // 保存当前URL，登录后可跳转回来
        localStorage.setItem('redirectPath', window.location.pathname)
        window.location.href = '/login'
      }
    }

    return Promise.reject(error)
  },
)

export default request
