import request from '@/utils/request'

// 新增联系人
/**
 *
 * @param data {"companyName":"","name":"","email":"","type":"","appellation":"","other":"","ccEmailList":[]}
 * @returns
 */
export const addContact = (data: {
  companyName?: string
  name?: string
  email?: string
  type?: string
  appellation?: string
  other?: string
  ccEmailList?: string[]
}) => {
  return request.post('/emailContact/add', data)
}

// 编辑联系人
/**
 *
 * @param data {"contactBizId":1,"companyName":"","name":"","email":"","type":"","appellation":"","other":"","ccEmailList":[]}
 * @returns
 */
export const editContact = (data) => {
  return request.put('/emailContact/edit', data)
}

// 删除联系人 delete
/**
 *
 * @param id 联系人id
 * @returns
 */
export const deleteContact = (id: number) => {
  return request.delete('/emailContact/del?contactBizId=' + id)
}

// 获取联系人详情
/**
 *
 * @param id 联系人id
 * @returns
 */
export const getContactDetail = (id: number) => {
  return request.get('/emailContact/detail', { params: { contactBizId: id } })
}

// 获取联系人列表 post
/**
 *
 * @param params {
"companyName": "", //公司名称（保险公司等）
"name": "", //联系人姓名
"email": "", //联系人邮箱
"pageNo": 1,
"pageSize": 1,
"sortField": "",
"sortOrder": ""
}
 * @returns
 */
export const getContactList = (params: {
  companyName?: string
  name?: string
  email?: string
  pageNo?: number
  pageSize?: number
  sortField?: string
  sortOrder?: string
}) => {
  return request.post('/emailContact/page', params)
}

/**服务商列表 */
/**
 *
 * @param params {
"providerName": "", //邮箱服务商名称
"pageNo": 1,
"pageSize": 1,
"sortField": "",
"sortOrder": ""
}
 * @returns
 */
export const getEmailProviderList = (params: {
  providerName?: string
  pageNo?: number
  pageSize?: number
  sortField?: string
  sortOrder?: string
}) => {
  return request.post('/emailProviderConfig/page', params)
}

// 新增发送配置
/**
 *
 * @param data {"emailSenderConfigBizId":1,"emailSenderConfigName":"","emailSenderConfigEmail":"","emailSenderConfigType":"","emailSenderConfigAppellation":"","emailSenderConfigOther":"","emailSenderConfigCcEmailList":[]}
 * @returns
 */
export const addEmailSenderConfig = (data: {
  email?: number
  password?: string
  providerBizId?: string
  displayName?: string
  active?: boolean
}) => {
  return request.post('/emailSenderConfig/add', data)
}

// 编辑发送配置
/**
 *
 * @param data {"emailSenderConfigBizId":1,"emailSenderConfigName":"","emailSenderConfigEmail":"","emailSenderConfigType":"","emailSenderConfigAppellation":"","emailSenderConfigOther":"","emailSenderConfigCcEmailList":[]}
 * @returns
 */
export const editEmailSenderConfig = (data: {
  senderBizId?: number
  email?: string
  password?: string
  providerBizId?: string
  displayName?: string
  active?: number
}) => {
  return request.put('/emailSenderConfig/edit', data)
}

// 删除发送配置
/**
 *
 * @param id 发送配置id
 * @returns
 */
export const deleteEmailSenderConfig = (id: string) => {
  return request.delete('/emailSenderConfig/del?senderBizId=' + id)
}

// 获取发送配置详情
/**
 *
 * @param id 发送配置id
 * @returns
 */
export const getEmailSenderConfigDetail = (id: string) => {
  return request.get('/emailSenderConfig/detail', { params: { senderBizId: id } })
}

// 获取发送配置列表
/**
 *
 * @param params {
"emailSenderConfigName": "", //发送配置名称
"emailSenderConfigEmail": "", //发送配置邮箱
"pageNo": 1,
"pageSize": 1,
"sortField": "",
"sortOrder": ""
}
 * @returns
 */
export const getEmailSenderConfigList = (params: {
  emailSenderConfigName?: string
  emailSenderConfigEmail?: string
  pageNo?: number
  pageSize?: number
  sortField?: string
  sortOrder?: string
}) => {
  return request.post('/emailSenderConfig/page', params)
}

// 分页查询变量
// 接口地址：/emailVariable/page
// 请求参数：{"variableNameCn":"","variableNameEn":"","pageNo":1,"pageSize":1,"sortField":"","sortOrder":""}
/**
 *
 * @param params {
"variableNameCn": "", //变量名称（中文）
"variableNameEn": "", //变量名称（英文）
"pageNo": 1,
"pageSize": 1,
"sortField": "",
"sortOrder": ""
}
 * @returns
 */
export const getEmailVariableList = (params: {
  variableNameCn?: string
  variableNameEn?: string
  pageNo?: number
  pageSize?: number
  sortField?: string
  sortOrder?: string
}) => {
  return request.post('/emailVariable/page', params)
}

// 新增变量
// 接口地址：/emailVariable/add
/**
 *
 * @param data {"variableNameCn": "", //变量字段名称中文名
"variableNameEn": "", //变量字段名称英文名
"description": "" //变量描述
}
 * @returns
 */
export const addEmailVariable = (data: {
  variableNameCn?: string
  variableNameEn?: string
  description?: string
}) => {
  return request.post('/emailVariable/add', data)
}

// 编辑变量
// 接口地址：/emailVariable/edit
/**
 *
 * @param data {"id": 1, //变量表主键ID
"variableBizId": "", //变量唯一业务ID
"variableNameCn": "", //变量字段名称中文名
"variableNameEn": "", //变量字段名称英文名
"description": "" //变量描述
}
 * @returns
 */
export const editEmailVariable = (data: {
  id?: number
  variableBizId?: string
  variableNameCn?: string
  variableNameEn?: string
  description?: string
}) => {
  return request.put('/emailVariable/edit', data)
}

// 删除变量
// 接口地址：/emailVariable/del?variableBizId=
// 请求参数：
/**
 *
 * @param id 变量id
 * @returns
 */
export const deleteEmailVariable = (id: string) => {
  return request.delete('/emailVariable/del?variableBizId=' + id)
}

/**
 * 新增变量分组
 * @param data {"variableGroupBizId": "", //变量分组唯一业务ID
"variableGroupName": "", //变量分组名称
"description": "" //变量分组描述
}
 * @returns
 */
export const addEmailVariableGroup = (data: {
  variableBizIdList?: string[]
  groupName?: string
  description?: string
}) => {
  return request.post('/emailVariableGroup/add', data)
}

/**
 * 编辑变量分组
 * @param data {"variableGroupBizId": "", //变量分组唯一业务ID
"variableGroupName": "", //变量分组名称
"description": "" //变量分组描述
}
 * @returns
 */
export const editEmailVariableGroup = (data: {
  variableGroupBizId?: string
  groupName?: string
  description?: string
  variableBizIdList?: string[]
}) => {
  return request.put('/emailVariableGroup/edit', data)
}

/**
 * 删除变量分组
 * @param id 变量分组id
 * @returns
 */
export const deleteEmailVariableGroup = (id: string) => {
  return request.delete('/emailVariableGroup/del?variableGroupBizId=' + id)
}

/**
 * 列表查询变量分组
 * @param params {
"variableGroupName": "", //变量分组名称
"pageNo": 1,
"pageSize": 1,
"sortField": "",
"sortOrder": ""
}
 * @returns
 */
export const getEmailVariableGroupList = (params: {
  groupName?: string
  pageNo?: number
  pageSize?: number
  sortField?: string
  sortOrder?: string
}) => {
  return request.post('/emailVariableGroup/page', params)
}

/**
 * 获取变量分组详情
 * @param id 变量分组id
 * @returns
 */
export const getEmailVariableGroupDetail = (id: string) => {
  return request.get('/emailVariableGroup/detail?variableGroupBizId=' + id)
}
