// 签名基础类型
export interface Signature {
  id: string | number
  name: string // 签名名称
  type: 'template' | 'custom' // 类型：模板型/自定义型
  isDefault: boolean // 是否默认签名
  config: {
    // 模板型签名配置
    companyName: string // 公司名称
    logoUrl: string // LOGO地址
    name: string // 姓名
    alias: string // 别名/职位
    phone: string // 电话
    email: string // 邮箱
    address: string // 地址
    // 字段显示配置
    showCompanyName: boolean
    showLogo: boolean
    showName: boolean
    showAlias: boolean
    showPhone: boolean
    showEmail: boolean
    showAddress: boolean
  }
  customContent: string // 自定义富文本内容
  createTime: string
  updateTime: string
}

// 签名字段配置项
export interface SignatureField {
  key: keyof Signature['config']
  label: string
  type: 'text' | 'image' | 'boolean'
  placeholder?: string
}
