// 菜单项接口定义
export interface MenuItem {
  name: string
  path: string
  icon: string
  title: string
}

// 菜单配置
export const menuConfig: MenuItem[] = [
  {
    name: 'compose',
    path: '/compose',
    icon: 'fas fa-pen',
    title: '写邮件',
  },
  {
    name: 'contacts',
    path: '/contacts',
    icon: 'fas fa-address-book',
    title: '联系人管理',
  },
  {
    name: 'senders',
    path: '/senders',
    icon: 'fas fa-user-circle',
    title: '发件人管理',
  },
  {
    name: 'variables',
    path: '/variables',
    icon: 'fas fa-file-excel',
    title: '变量管理',
  },
  // {
  //   name: 'signatures',
  //   path: '/signature-management',
  //   icon: 'fas fa-file-excel',
  //   title: '签名管理',
  // },
  {
    name: 'emails',
    path: '/emails',
    icon: 'fas fa-history',
    title: '邮件记录',
  },
]

// 页面标题映射
export const pageTitles: Record<string, string> = {
  compose: '写邮件',
  contacts: '联系人管理',
  senders: '发件人管理',
  variables: '变量管理',
  emails: '邮件记录',
  // signatures: '签名管理',
}
