import { fileURLToPath, URL } from 'node:url'

import { defineConfig } from 'vite'
import vue from '@vitejs/plugin-vue'
import vueJsx from '@vitejs/plugin-vue-jsx'
import vueDevTools from 'vite-plugin-vue-devtools'

// https://vite.dev/config/
export default defineConfig({
  // 关键配置：设置基础路径为子目录 yd-email
  // 生产环境（部署到服务器）用 '/yd-email/'，本地开发用 '/'（避免开发时路径错误）
  base: process.env.NODE_ENV === 'production' ? '/yd-email/' : '/',
  plugins: [vue(), vueJsx(), vueDevTools()],
  resolve: {
    alias: {
      '@': fileURLToPath(new URL('./src', import.meta.url)),
    },
  },
})
