import api from "../api/api";
// 白名单，不需要携带token就允许被访问的接口
const whiteApiList = ['/api/authorize/obtainToken']

export const interceptor = () => {

  uni.addInterceptor('request', {
  
  // 请求拦截器
    invoke(args) {
    console.log('请求拦截器',args);
    // 加载loading
      uni.showLoading({
        title: '加载中...'
      })
      
      // 当本地没有token，并且接口地址没在白名单内，需要重新获取token
      if (!uni.getStorageSync('uni-token') && !whiteApiList.includes(args.url)) {
		uni.request({
			url:'/api/authorize/obtainToken',
			method:'POST',
			data:{ticket: 'uni-app'},
			success: (res) => {
				if(res.statusCode===200){
					uni.setStorageSync('uni-token',res.data['data']['token']);
					window.location.href = window.location.href + '?' + 't_reload=' + new Date().getTime();
				}
				console.log(res)
			}
		})
        uni.hideLoading()
        return false
      }
      // request 触发前拼接 url
      
      //设置请求头及token
      args.header = {
        'content-type': args.method === 'POST' ? 'application/json' : 'application/x-www-form-urlencoded',
        'X-Authorization': uni.getStorageSync('uni-token')
      }
      console.log(args.header)
    },
    
    // 响应拦截器，可以对数据进行预处理
    success(args) {
      uni.hideLoading()
      console.log(args);
    },
    fail(err) {
      console.log('interceptor-fail', err)
      console.log('请求失败')
      uni.hideLoading()
    },
    complete(res) {
      uni.hideLoading()
    }
  })
}
