export default {
	// 数据处理
	action(data){ // 使用递归函数
	    // if(!(data?.length <= 0)){ 
	    // 等价于
		if(!data || data.length <= 0){ // 递归的出口
			return null;
		}
		return data.map(x => { // 循环数据
		    const model = { // 把后端返回过来的数据里面的键给替换成我想要的键
			    source: x,
				text: x.provinceName ? x.provinceName : x.cityName,
				value: x.cityId ? x.cityId : x.provinceId,
			};
		    const children = this.action(x.citys); // 子级数据
		    if(children){ // 一直往下循环查找有没有children这个键，如果有就直接添加一个子级字段名，这个字段名就是存子级数据
			    model.children = children;
		    }		
		return model; // 返回这个数据
		});
	},
	// 封装报错弹窗
	errorDialog(type,content){
		// type 1 必填项校验 2 规则校验
		uni.showModal({
		  title: type===1 ? '必填项校验' : '规则校验',
		  content:content,
		  showCancel:false,
		  success: function (res) {
				  if (res.confirm) {
						  console.log('用户点击确定');
				  } else if (res.cancel) {
						  console.log('用户点击取消');
				  }
		  }
		});
	},
	// 小数处理
	/*
	num:源数据
	digitNum:保留几位小数
	type:向上(1)取
	*/
	formatFloat(num,digitNum=2,type=1){
		if(num){
			if(type===1){
				const dataNum = (num * Math.pow(10, digitNum + 1) / Math.pow(10, digitNum + 1)).toString();
				if(dataNum.indexOf('.')>-1){
					return (Number(dataNum.slice(0, dataNum.indexOf('.') + digitNum + 1)) + 10 / Math.pow(10, digitNum + 1)).toFixed(digitNum)
				}else{
					return dataNum;
				}
			}else{
				return (num * Math.pow(10, digitNum + 1) / Math.pow(10, digitNum + 1)).toFixed(digitNum)
			}
		}else{
			return num;
		}
	}
	

}