import { Component, OnInit } from '@angular/core';
import { MyService } from '../my.service';
@Component({
  selector: 'ydlife-salary',
  templateUrl: './salary.component.html',
  styleUrls: ['./salary.component.scss']
})
export class SalaryComponent implements OnInit {
  practitionerIdEG: any;
  payScaleInfos: Array<any>;
  constructor(private myService: MyService) { }

  ngOnInit() {
    this.practitionerIdEG = JSON.parse(localStorage.getItem('lifeCustomerInfo'))['practitionerIdEG'];
    this.payScaleListQuery();
  }

  payScaleListQuery() {
    this.myService.payScaleListQuery({ practitionerIdEG: this.practitionerIdEG }).subscribe((res) => {
      console.log(res)
      if (res['success']) {
        this.payScaleInfos = res['data']['payScaleInfos'];
      } else {
        this.payScaleInfos = [];
      }
    })
  }

  //下载pdf
  getPdf(monShId) {

    this.myService.payScalePdf({ monShId: monShId })
  }
}
