import { Component, OnInit } from '@angular/core';
import { MyService } from '../my.service';
import { EChartOption } from 'echarts';
import { borderBottomLeftRadius } from 'html2canvas/dist/types/css/property-descriptors/border-radius';


@Component({
  selector: 'ydlife-my-management',
  templateUrl: './my-management.component.html',
  styleUrls: ['./my-management.component.scss']
})
export class MyManagementComponent implements OnInit {
  optList:Array<any>;
  isTeam:number = 0;//0个人；1团队
  chartOption: EChartOption = {}
  personY:Array<any>;
  detailList:Array<any>;
  zeroList:Array<any>;
  fiftyList:Array<any>;
  seventyList:Array<any>;
  ninetyNineList:Array<any>;
  hundredList:Array<any>;
  constructor(private myService: MyService) { }

  ngOnInit() {
    this.dropOptionsQuery('yd_trainning_file_type');
    this.changeIsTeam(0);
  }

  dropOptionsQuery(code){
    this.myService.dropOptionsQuery({code:code}).subscribe((res)=>{
      if(res['success']){
        this.optList = res['data']['dropMasterInfoList'][0]['dropOptionsInfoList'].filter((item)=>{
          return item.dropOptionCode != 'productTraining' && item.dropOptionCode!= 'trainingVideo'
        });
      }
      
    })
  }

  changeIsTeam(isTeam){
    this.isTeam = isTeam;
    const params = {
      dateSpan:'2022-08-31 23:59:59',
      practitionerId:25,
      // practitionerId:JSON.parse(localStorage.getItem('lifeCustomerInfo'))['practitionerId'],
      mdDropOptionCode:null
    }
    if(this.isTeam == 0){
      this.myService.personalCompletionRate(params).subscribe((res)=>{
        console.log(res)
        if(res['success']){
          this.zeroList = res['data']['zeroList'];
          this.fiftyList = res['data']['fiftyList'];
          this.seventyList = res['data']['seventyList'];
          this.ninetyNineList = res['data']['ninetyNineList'];
          this.hundredList = res['data']['hundredList'];
        }else{
          this.zeroList = this.fiftyList = this.seventyList = this.ninetyNineList =  this.hundredList = [];
        }
        this.detailList = this.zeroList.concat(this.fiftyList).concat(this.seventyList).concat(this.ninetyNineList).concat(this.hundredList)
        this.personY = [].concat(this.zeroList.length).concat(this.fiftyList.length).concat(this.seventyList.length).concat(this.ninetyNineList.length).concat(this.hundredList.length)
        this.chartOption = {
          xAxis: {
            type: 'category',
            data: ['0', '1-50', '51-70', '71-99', '100']
          },
          yAxis: {
            type: 'value'
          },
          series: [
            {
              data: this.personY,
              type: 'bar',
              showBackground: true,
              barWidth: 40,
              backgroundStyle: {
                color: 'rgba(180, 180, 180, 0.2)'
              },
              itemStyle: {
                color: '#333',
                shadowColor: '#91cc75',
                borderType: 'dashed',
                opacity: 0.9,
                barBorderRadius:2,
                normal:{
                  label:{
                    formatter:"{c} 人",
                    show:true,
                    position:"top",
                    textStyle:{
                      fontWeight:"border",
                      fontSize:12,
                      color:"#333"
                    }
                  }
                }
              }
            }
          ]
        };
      })
      
    }
    if(this.isTeam == 1){
      this.myService.teamCompletionRate(params).subscribe((res)=>{
        console.log(res)
        if(res['success']){
          this.zeroList = res['data']['zeroList'];
          this.fiftyList = res['data']['fiftyList'];
          this.seventyList = res['data']['seventyList'];
          this.ninetyNineList = res['data']['ninetyNineList'];
          this.hundredList = res['data']['hundredList'];
        }else{
          this.zeroList = this.fiftyList = this.seventyList = this.ninetyNineList =  this.hundredList = [];
        }
        this.detailList = this.zeroList.concat(this.fiftyList).concat(this.seventyList).concat(this.ninetyNineList).concat(this.hundredList)
        this.chartOption = {
          xAxis: {
            type: 'category',
            data: ['天使', '冠军', '多多', '王一一']
          },
          yAxis: {
            type: 'value'
          },
          series: [
            {
              data: [20, 40, 60, 100],
              type: 'bar',
              showBackground: false,
              barWidth: 40,
              backgroundStyle: {
                color: 'rgba(180, 180, 180, 0.2)'
              },
              itemStyle: {
                color: '#9EB4FF',
                shadowColor: '#91cc75',
                borderType: 'dashed',
                opacity: 0.9,
                barBorderRadius:2
              }
            }
          ]
        };
      })
    }
  }
 
}
