import { Component, OnInit } from '@angular/core';
import { MyService } from '../my.service'
import { ActivatedRoute,Router } from "@angular/router";

@Component({
  selector: 'ydlife-approval-result-list',
  templateUrl: './approval-result-list.component.html',
  styleUrls: ['./approval-result-list.component.scss']
})
export class ApprovalResultListComponent implements OnInit {
  approvalIdentity:any;
  hiringBasicInfoId:any;
  practitionerId:any;
  recordsList:Array<any>;
  constructor(private myService:MyService,private activatedRoute: ActivatedRoute) { }

  ngOnInit() {
    this.approvalIdentity = this.activatedRoute.snapshot.queryParams.approvalIdentity?this.activatedRoute.snapshot.queryParams.approvalIdentity:null;
    this.hiringBasicInfoId = this.activatedRoute.snapshot.queryParams.hiringBasicInfoId?this.activatedRoute.snapshot.queryParams.hiringBasicInfoId:null;
    this.practitionerId = JSON.parse(localStorage.getItem('lifeCustomerInfo'))['practitionerId'];
    this.PractitionerHiringApproveRecords();
  }

  PractitionerHiringApproveRecords(){
    const param = {
      practitionerId:this.practitionerId,
      hiringBasicInfoId:this.hiringBasicInfoId,
      approvalIdentity:this.approvalIdentity
      
    }
    this.myService.detailQuery(param).subscribe((res)=>{
      console.log(res)
      if(res['success']){
        this.recordsList = res['data']['hiringApproveRecordsList'];
      }
    })
  }
  
}
