import {Component, OnInit} from '@angular/core';
import {Router} from "@angular/router";

@Component({
  selector: 'ydlife-my-center-home',
  templateUrl: './my-center-home.component.html',
  styleUrls: ['./my-center-home.component.scss']
})
export class MyCenterHomeComponent implements OnInit {
  menuLists: Array<any>;
  isNeedAlert: boolean;
  dialogInfo: any;

  constructor(private router: Router) {
  }

  ngOnInit() {
    this.menuLists = [
      {no: 1, title: '重要公告', path: 'https://www.ydinsurance.cn/?page_id=13763', icon: 'icon-gonggao', routerLink: ''},
      {no: 2, title: '业绩资讯', path: '', icon: 'icon-icon-test', routerLink: ''},
      {no: 3, title: '我的客户', path: '', icon: 'icon-kehu', routerLink: ''},
      {no: 4, title: '保单查询', path: '', icon: 'icon-baodanyangben', routerLink: ''},
      {no: 5, title: '教育训练', path: '', icon: 'icon-jiaoyu', routerLink: ''},
      {no: 6, title: '文件下载', path: 'https://www.ydinsurance.cn/?page_id=13957', icon: 'icon-xiazai', routerLink: ''},
      {no: 7, title: '产品海报', path: '', icon: 'icon-sucai', routerLink: 'material'},
      {no: 0, title: '退出登录', path: '', icon: 'icon-tuichu', routerLink: ''},
    ];
  }

  // 菜单导航
  menuNavigation(item) {
    if (item.routerLink) {
      this.router.navigate([`./${item.routerLink}`]);
    } else if (item.path) {
      window.open(item.path);
    } else if (item.no === 0) {
      localStorage.removeItem('lifeCustomerInfo');
      this.router.navigate(['/login']);
    } else {
      this.isNeedAlert = true;
      this.dialogInfo = {
        title: null,
        content: {value: '即将开发，敬请期待！', align: 'center'},
        footer: [{value: '我知道了', routerLink: '', className: 'weui-dialog__btn_primary'}],
      };
    }
  }

  // 关闭弹窗
  getPopInfo() {
    this.isNeedAlert = false;
  }
}
