import { Component, OnInit  } from '@angular/core';
import { LifeCommonService } from 'src/app/common/life-common.service';
import { MyService } from '../my.service';

@Component({
  selector: 'ydlife-integration-detail',
  templateUrl: './integration-detail.component.html',
  styleUrls: ['./integration-detail.component.scss']
})
export class IntegrationDetailComponent implements OnInit {
  integralGrantInfos:Array<any>;
  lists:Array<any>;
  status:number = 1;
  searchDateFormat:Date = new Date(new Date().getFullYear(), 0);
  searchDateEndFormat:Date = new Date(new Date().getFullYear(),new Date().getMonth() +1,0);
  constructor(private myService:MyService,private lifeCommonService:LifeCommonService) { }

  ngOnInit() {
    this.queryPractitionerIntegralList(this.lifeCommonService.dateFormat(this.searchDateFormat,'yyyy-MM-01'),this.lifeCommonService.dateFormat(this.searchDateEndFormat,'yyyy-MM-dd'));
  }
  queryLists(status){
    this.status = status;
    this.queryPractitionerIntegralList(this.lifeCommonService.dateFormat(this.searchDateFormat,'yyyy-MM-01'),this.lifeCommonService.dateFormat(this.searchDateEndFormat,'yyyy-MM-dd'),this.status);
  }
  queryPractitionerIntegralList(queryDateStart=null,queryDateEnd=null,queryStatus=1){
    this.myService.queryPractitionerIntegralList({queryStatus:queryStatus,practitionerId:localStorage.getItem('lifeCustomerInfo')?JSON.parse(localStorage.getItem('lifeCustomerInfo'))['practitionerId']:null,queryDateStart:queryDateStart,queryDateEnd:queryDateEnd}).subscribe(res=>{
      if(res['success']){
        this.lists = this.integralGrantInfos = res['data']['integralGrantInfos']
      }
    })
  }

  onOk(result: Date) {
    this.searchDateEndFormat = new Date(this.searchDateEndFormat.getFullYear(),this.searchDateEndFormat.getMonth() + 1,0);
    this.queryPractitionerIntegralList(this.lifeCommonService.dateFormat(this.searchDateFormat,'yyyy-MM-01'),this.lifeCommonService.dateFormat(this.searchDateEndFormat,'yyyy-MM-dd'));
  }
}
