import { Component, OnInit } from '@angular/core';
import { MyService } from '../my.service';

@Component({
  selector: 'ydlife-joint-sales',
  templateUrl: './joint-sales.component.html',
  styleUrls: ['./joint-sales.component.scss']
})
export class JointSalesComponent implements OnInit {
  index = 0;
  unionSalesInfos:Array<any>;

  onTabClick(i) {
    // console.log('onTabClick', item);
    this.index = i;
    let status;
    if(i==0){
      status = 1;
    }else if(i==1){
      status = 2;
    }else if(i==2){
      status = 3;
    }
    this.queryUnionSalesList(status);
  }
  constructor(private myService:MyService) { }


  ngOnInit() {
    this.queryUnionSalesList(1);
  }


  queryUnionSalesList(signStatus){
    this.myService.queryUnionSalesList({signStatus:signStatus,isActive:1,practitionerId:JSON.parse(localStorage.getItem('lifeCustomerInfo'))['practitionerId']}).subscribe(res=>{
      if(res['success']){
        this.unionSalesInfos = res['data']['unionSalesInfos'];
      }
    })
  }
}
