import { Component, OnInit } from '@angular/core';
import { Router } from "@angular/router";
import { MyService } from "../my.service";

@Component({
  selector: 'ydlife-mk-material',
  templateUrl: './mk-material.component.html',
  styleUrls: ['./mk-material.component.scss']
})
export class MkMaterialComponent implements OnInit {
  posterInfos: Array<any>;
  categoryList: Array<any>;
  selectedCategoryId: number;

  constructor(private router: Router, private myService: MyService) {
  }

  ngOnInit() {
    this.dropOptionsQuery();
  }

  posterQuery() {
    const param = {
      mdDropOptionId: this.selectedCategoryId,
      paginationInfo: { noLimitFlag: 'CONFIRM' }
    }
    this.myService.posterQuery(param).subscribe(res => {
      if (res['success']) {
        this.posterInfos = res['data']['posterInfos'];
      }
    });
  }

  //海报分类
  dropOptionsQuery() {
    this.myService.dropOptionsQuery({ code: 'yd_productbill_file_type' }).subscribe(res => {
      if (res['success']) {
        this.categoryList = res['data']['dropMasterInfoList'][0]['dropOptionsInfoList'];
        if (this.categoryList.length > 0) {
          this.selectedCategoryId = this.categoryList[0].id;
          this.posterQuery();
        }
      } else {
        this.categoryList = [];
      }
    })
  }

  switchCategory(e) {
    this.selectedCategoryId = e;
    this.posterQuery();
  }
}
