import {Component, OnDestroy, OnInit} from '@angular/core';
import { MyService } from '../my.service';

@Component({
  selector: 'ydlife-business-card',
  templateUrl: './business-card.component.html',
  styleUrls: ['./business-card.component.scss']
})
export class BusinessCardComponent implements OnInit {
  lifeCustomerInfo: any;
  practitionerInfo:any;
  isNeedAlert: boolean;
  dialogInfo: any;
  constructor(private myService:MyService) {
  }

  ngOnInit() {
    this.lifeCustomerInfo = JSON.parse(localStorage.getItem('lifeCustomerInfo'));
    this.businessCard();
  }

  savePicture(Url) {
		var blob = new Blob([''], { type: 'application/octet-stream' });
		var url = URL.createObjectURL(blob);
		var a = document.createElement('a');
		a.href = Url;
		a.download = Url.replace(/(.*\/)*([^.]+.*)/ig, "$2").split("?")[0];
		var e = document.createEvent('MouseEvents');
		e.initMouseEvent('click', true, false, window, 0, 0, 0, 0, 0, false, false, false, false, 0, null);
		a.dispatchEvent(e);
		URL.revokeObjectURL(url);
	}

  // 申请企业邮箱
  applyEmail(){
    this.myService.applyEmail({practitionerId:this.practitionerInfo.practitionerId,email:this.practitionerInfo.email}).subscribe(res=>{
      this.isNeedAlert = true;
     if(res['success']){
      this.dialogInfo = {
        title: null,
        content: { value: '您的银盾保险专属办公邮箱将在２个工作日内为您生成，欢迎使用！祝业绩长虹！', align: 'center' },
        footer: [{ value: '确认', routerLink: '', className: 'weui-dialog__btn_primary' }],
      };
     }else{
      this.dialogInfo = {
        title: null,
        content: { value: res['message'], align: 'center' },
        footer: [{ value: '确认', routerLink: '', className: 'weui-dialog__btn_primary' }],
      };
     }
    })
   
    
  }

  getPopInfo() {
    this.isNeedAlert = false;
  }
  businessCard(){
    this.myService.businessCard({practitionerId:this.lifeCustomerInfo.practitionerId,businessCardType:2}).subscribe(res=>{
      if(res['success']){
        this.practitionerInfo = res['data'];
        this.practitionerInfo.certificateList = this.practitionerInfo.certificateList.splice(0,3)
      }
    })
  }

}
