import { Component, OnInit } from '@angular/core';
import { LifeCommonService } from '../../common/life-common.service';
const extra = {
  '2017/07/15': { info: 'Disable', disable: true }
};

const now = new Date();
extra[+new Date(now.getFullYear(), now.getMonth(), now.getDate() + 5)] = { info: 'Disable', disable: true };
extra[+new Date(now.getFullYear(), now.getMonth(), now.getDate() + 6)] = { info: 'Disable', disable: true };
extra[+new Date(now.getFullYear(), now.getMonth(), now.getDate() + 7)] = { info: 'Disable', disable: true };
extra[+new Date(now.getFullYear(), now.getMonth(), now.getDate() + 8)] = { info: 'Disable', disable: true };

for (let key in extra) {
  if (extra.hasOwnProperty(key)) {
    let info = extra[key];
    const date = new Date(key);
    if (!Number.isNaN(+date) && !extra[+date]) {
      extra[+date] = info;
    }
  }
}
@Component({
  selector: 'ydlife-todo-list',
  templateUrl: './todo-list.component.html',
  styleUrls: ['./todo-list.component.scss']
})
export class TodoListComponent implements OnInit {
  weekArr: Array<any>;
  taskList:Array<any> = [];
  taskTimeList:Array<any> = [];
  state: any = {
    en: false,
    date: null,
    show: false,
    pickTime: false,
    now: new Date(),
    type: 'range',
    enterDirection: '',
    rowSize: 'normal',
    showShortcut: false,
    infinite: true,
    defaultValue: undefined,
    minDate: new Date(+now - 5184000000),
    maxDate: new Date(+now + 31536000000),
    onSelect: undefined,
  }
  constructor(private lifeCommonService: LifeCommonService) {
    this.taskTimeList = [
      {id:1,time:'8:00'},
      {id:2,time:'9:00'},
      {id:3,time:'10:00'},
      {id:4,time:'11:00'},
      {id:5,time:'12:00'},
      {id:6,time:'13:00'},
      {id:7,time:'14:00'},
      {id:8,time:'15:00'},
      {id:9,time:'16:00'},
      {id:10,time:'17:00'},
      {id:11,time:'18:00'},
      {id:12,time:'19:00'},
    ]
   }
  
  ngOnInit() {
    this.weekArr = this.lifeCommonService.makeDate();
  }

  goBack(){
    history.go(-1)
  }

  selectDay(weekItem){
    for(let i=0;i<this.weekArr.length;i++){
      this.weekArr[i].selected = false;
      if(weekItem.day == this.weekArr[i]['day']){
        this.weekArr[i].selected = true;
      }
    }
  }

  addTask(){
    this.taskList.push({time:'8:00-9:00',isImportant:true,taskTitle:'今天要完成的计划1',taskContent:'app界面和网页界面的设计'});
  }
}
