import {Injectable} from '@angular/core';

import {Observable, of} from 'rxjs';
import {tap, delay} from 'rxjs/operators';
import {environment} from '../../environments/environment';
import {HttpClient, HttpHeaders} from '@angular/common/http';
import {retry} from 'rxjs/internal/operators';

@Injectable({
  providedIn: 'root',
})
export class AuthService {
  constructor(private http: HttpClient) {
  }

  private API = environment.BACKEND_URL_CONFIG_VALUE;
  isLoggedIn = false;
// store the URL so we can redirect after logging in
  redirectUrl: string;
// 经纪人登陆
  login(loginInfo): Observable<any> {
    const api = this.API + '/practitionerLogin';
    const httpOptions = {
      headers: new HttpHeaders({
          'Content-Type': 'application/json',
          'X-Authorization': localStorage.getItem('lifeToken') ? localStorage.getItem('lifeToken') : ''
        }
      )
    };
    return this.http.post(api, JSON.stringify(loginInfo), httpOptions)
      .pipe(
        retry(3),
      );
  }

//  发送验证码
  verificationCode(verticalCode) {
    const url = this.API + '/verificationCode';
    const httpOptions = {
      headers: new HttpHeaders({
          'Content-Type': 'application/json',
          'X-Authorization': localStorage.getItem('lifeToken') ? localStorage.getItem('lifeToken') : ''
        }
      )
    };
    return this.http
      .post(url, JSON.stringify(verticalCode), httpOptions)
      .pipe(
        tap(response => response)
      );
  }

//  校验验证码
  compare(compareCode) {
    const url = this.API + '/checkVerificationCode';
    const httpOptions = {
      headers: new HttpHeaders({
          'Content-Type': 'application/json',
          'X-Authorization': localStorage.getItem('lifeToken') ? localStorage.getItem('lifeToken') : ''
        }
      )
    };
    return this.http
      .post(url, JSON.stringify(compareCode), httpOptions)
      .pipe(
        tap(response => response)
      );
  }

  /**
   * 获取TOKEN
   */
  obtainToken() {
    const url = this.API + '/authorize/obtainToken';
    const ticketObj = {
      ticket: 'life'
    };
    const httpOptions = {
      headers: new HttpHeaders({
          'Content-Type': 'application/json'
        }
      )
    };
    return this.http.post(url, JSON.stringify(ticketObj), httpOptions)
      .pipe(
        tap(response => {
          return response;
        })
      );
  }
}
