import { Component, OnInit,ViewChild,ElementRef } from '@angular/core';
import { MyService } from '../../my.service';
import { ActivatedRoute,Router } from "@angular/router";
import { LifeCommonService } from "../../../common/life-common.service";

@Component({
  selector: 'ydlife-employee-id-card',
  templateUrl: './employee-id-card.component.html',
  styleUrls: ['./employee-id-card.component.scss']
})
export class EmployeeIdCardComponent implements OnInit {
  @ViewChild('mainScreen') elementView: ElementRef;
  exampleWidth:any;
  exampleHeight:any;
  hiringBasicInfoId:any;
  constructor(private activatedRoute: ActivatedRoute,
    private router: Router,public lifeCommonService:LifeCommonService,
    public myService:MyService) { 
      
    }

  ngOnInit() {
    const title = this.activatedRoute.snapshot.data[0]['title'];
    this.lifeCommonService.setTitle(title);
    this.hiringBasicInfoId = this.activatedRoute.snapshot.queryParams.hiringBasicInfoId?this.activatedRoute.snapshot.queryParams.hiringBasicInfoId:null;
    setTimeout(() => {
      this.exampleWidth = this.elementView.nativeElement.offsetWidth;
      this.exampleHeight =this.elementView.nativeElement.offsetHeight; 
    }, 300);
    
  }

  next(){
    this.router.navigate(['/employee_education'],{ queryParams: { hiringBasicInfoId:this.hiringBasicInfoId} });
  }

}
