import { Component, OnInit } from "@angular/core";
import { AuthService } from '../../../auth/auth.service';
import { ActivatedRoute,Router } from "@angular/router";
import { LifeCommonService } from "../../../common/life-common.service";
@Component({
  selector: "ydlife-register",
  templateUrl: "./register.component.html",
  styleUrls: ["./register.component.scss"],
})
export class RegisterComponent implements OnInit {
  constructor(public authService: AuthService, 
    private activatedRoute: ActivatedRoute,
    private router: Router,
    public lifeCommonService: LifeCommonService) {}
  MOBILE_REGEXP = /^(1)\d{10}$/;
  sendCodeHtml: string = '获取验证码';
  timer: any;
  remainTimes: number = 60;
  disabledSendBtn: boolean = false;
  userInfo: any = {
    mobileNo: null,
    verificationCode: null
  };
  isNeedAlert: boolean;
  dialogInfo: any;
  redirect: any;
  //控制弹框
  toastDialog: boolean;
  toastInfo: any;
  hiringBasicInfoId:any;
  ngOnInit() {
    const title = this.activatedRoute.snapshot.data[0]['title'];
    this.lifeCommonService.setTitle(title);
    this.hiringBasicInfoId = this.activatedRoute.snapshot.queryParams.hiringBasicInfoId?this.activatedRoute.snapshot.queryParams.hiringBasicInfoId:null;
    console.log(this.hiringBasicInfoId)
  }

  inputBlur() {
    window.scrollTo(0, 0);
  }

    //  发送验证码
    verificationCode() {
      const verificationInfo = {
        mobileNo: this.userInfo.mobileNo,
        type: '1'
      };
      if (this.MOBILE_REGEXP.test(this.userInfo.mobileNo) && !this.disabledSendBtn) {
        this.authService.verificationCode(verificationInfo).subscribe(res => {
          if (res['success']) {
            this.countDown();
          } else {
            this.openPopInfo(res['message']);
          }
        });
      } else if (!this.MOBILE_REGEXP.test(this.userInfo.mobileNo)) {
        this.openPopInfo('手机号不正确');
      }
    }
  
    //  倒计时
    countDown() {
      this.disabledSendBtn = true;
      this.timer = setInterval(() => {
        this.remainTimes--;
        this.sendCodeHtml = `${this.remainTimes}(S)`;
        if (this.remainTimes <= 0) {
          this.sendCodeHtml = '获取验证码';
          this.remainTimes = 60;
          this.disabledSendBtn = false;
          clearInterval(this.timer);
        }
      }, 1000);
    }

    // 打开弹窗
    openPopInfo(message) {
      this.isNeedAlert = true;
      this.dialogInfo = {
        title: null,
        content: { value: message, align: 'center' },
        footer: [{ value: '我知道了', routerLink: '', className: 'weui-dialog__btn_primary' }],
      };
    }

   // 关闭弹窗
   getPopInfo() {
    this.isNeedAlert = false;
  }

  checkVerificationCode(){
    if(!this.userInfo.mobileNo){
      this.toastDialog = true;
      this.toastInfo = {
        status: 1,
        msg: '手机号不能为空！',
        timeout: 3000,
        align: 'center'
      };
      return;
    }
    if(!this.userInfo.verificationCode){
      this.toastDialog = true;
      this.toastInfo = {
        status: 1,
        msg: '验证码不能为空！',
        timeout: 3000,
        align: 'center'
      };
      return;
    }
    const compareCodeObj = {
      mobileNo: this.userInfo.mobileNo,
      verificationCode: this.userInfo.verificationCode,
      expireTime: '3600'
    };
    this.authService.compare(compareCodeObj).subscribe((res)=>{
      if(res['success']){
        this.router.navigate(['/employee_info'],{ queryParams: { hiringBasicInfoId:this.hiringBasicInfoId} });
      }else{
        this.openPopInfo(res['message']);
      }
    })
  }
}
