import { Component, OnInit } from '@angular/core';
import { MyService } from '../my.service';
import { LifeCommonService } from '../../common/life-common.service';
import { Router , ActivatedRoute} from "@angular/router";
import {Location} from '@angular/common';

@Component({
  selector: 'ydlife-my-business',
  templateUrl: './my-business.component.html',
  styleUrls: ['./my-business.component.scss'],
})
export class MyBusinessComponent implements OnInit {
  businessList: Array<any>;
  isTaskCome:boolean = false;
  pageType:any;
  showBusinessList: Array<any>;
  isSelectFlag:boolean;
  selectedBusiness:any;
   //控制弹框
   toastDialog: boolean;
   toastInfo: any;
  //  是否要删除
  isDelFlag:boolean = false;
  selectedOpportunityId:string;
  dialogInfo:any;
  constructor(private myService: MyService, public lifeCommonService: LifeCommonService, private router: Router,private activatedRoute: ActivatedRoute,private location:Location) { 
    this.pageType = this.activatedRoute.snapshot.data[0]['type'];
  }

  ngOnInit() {
    this.ownOpportunityQuery();
  }

  del(e){
    event.stopPropagation();
    this.isDelFlag = true;
    this.selectedOpportunityId = e;
    this.dialogInfo = {
      title: null,
      content: {value: '确认要删除此商机吗？', align: 'center'},
      footer: [{value: '取消', routerLink: '', className: 'weui-dialog__btn_primary'},{value: '确定', routerLink: '', className: ''}],
    };
  }

  popInfo(e){
    this.isDelFlag = false;
    if(e==='确定'){
      this.deleteOpportunity();
    }
    
  }
  // 删除商机
  deleteOpportunity(){
    this.myService.deleteOpportunity({opportunityId:this.selectedOpportunityId,practitionerId:JSON.parse(localStorage.getItem('lifeCustomerInfo'))['practitionerId']}).subscribe(res=>{
      this.isDelFlag = true;
      this.dialogInfo = {
        title: null,
        content: {value: res['message'], align: 'center'},
        footer: [{value: '我知道了', routerLink: '', className: 'weui-dialog__btn_primary'}],
      };
      if(res['success']){
        this.ownOpportunityQuery();
      }
    })
  }

  ownOpportunityQuery() {
    const brokerCustomerId = JSON.parse(localStorage.getItem('lifeCustomerInfo'))['customerId'];
    const brokerPractitionerId = JSON.parse(localStorage.getItem('lifeCustomerInfo'))['practitionerId'];
    this.myService.ownOpportunityQuery({ customerId: brokerCustomerId, practitionerId: brokerPractitionerId }).subscribe((res) => {
      if (res['data']['ownOpportunityInfos']) {
          this.businessList = res['data']['ownOpportunityInfos'];
          this.showBusinessList = res['data']['ownOpportunityInfos'];
      } else {
        this.businessList = [];
        this.showBusinessList = [];
      }
    })
  }

  addBussiness() {
    //清空从我的客户带过来的客户信息
    localStorage.removeItem('myCustomerInfo')
    this.router.navigate(['/business/0']);
  }

  isJumpToDetail(opportunityId,orderId,leadsAssignedId,businessItem?:any){
    if(this.pageType == 'business'){
      this.router.navigate([`/business/${opportunityId}`], { queryParams: { orderId: orderId, leadsAssignedId: leadsAssignedId } });
    }else{
      if(!this.selectedBusiness){
        this.selectedBusiness = businessItem; 
      }else{
        this.selectedBusiness = undefined;
      }
      return;
    }
  }

  change(event){
    this.showBusinessList = this.businessList.filter((item)=>{
      if(item.name){
        return item.name.indexOf(event) !=-1;
      }
    })
  }

  returnAddTask(){
    if(this.selectedBusiness){
      const {leadsAssignedId,opportunityId}=this.selectedBusiness;
      // this.router.navigate(['/addtask/'], { queryParams: { customerId:opportunityId , referLeadsId: leadsAssignedId },state:this.selectedBusiness});
      this.router.navigate(['/addtask/'], { queryParams: { customerId:opportunityId , referLeadsId: leadsAssignedId }});
    }else{
      this.router.navigate(['/addtask/']);
      // this.toastDialog = true;
      // this.toastInfo = {
      //   status: 1,
      //   msg:'请选择您需要关联的商机！',
      //   timeout: 3000,
      //   align: 'center'
      // };
      // return;
    }
  }
}
