import { Component, OnDestroy, OnInit } from '@angular/core';
import { Router } from '@angular/router';
import { MyService } from '../my.service';
declare var rrweb:any;

@Component({
  selector: 'ydlife-e-notice-sign',
  templateUrl: './e-notice-sign.component.html',
  styleUrls: ['./e-notice-sign.component.scss']
})
export class ENoticeSignComponent implements OnInit,OnDestroy {
  timerId:any;
  events:Array<any>;
  pageInfo = {
    type:6,
    name:'客户告知书同意并签署页面'
  }
  constructor(private router:Router,private myService:MyService) { }

  ngOnInit() {
    let _this = this;
    _this.events = [];
    rrweb.record({
      emit(event){
        // 将evene存入events数组中
        _this.events.push(event);
      }
    });
    this.timerId = setInterval(()=>{ this.saveRecord()},10 * 1000)
  }
  ngOnDestroy(): void {
    clearInterval(this.timerId)
}

  saveRecord(){
    this.myService.rrwebInfo(this.events,this.pageInfo).subscribe(res=>{
      // console.log(res);
    })
  }
  agree(){
    this.saveRecord();
    this.myService.customerBehaviorTrackSave(`客户告知书 - 客户点击了【同意并签署】`).subscribe(res=>{
      this.router.navigate(['/eNoticeSignature'],{ queryParams: { type:'eNotice'} })
    })
  }

}
