import { Component, OnInit ,ChangeDetectorRef} from '@angular/core';
import { MyService } from '../../my.service';
import { ActivatedRoute,Router } from "@angular/router";
import { LifeCommonService } from "../../../common/life-common.service";
declare const wx: any;
@Component({
  selector: 'ydlife-qrcode-upload',
  templateUrl: './qrcode-upload.component.html',
  styleUrls: ['./qrcode-upload.component.scss']
})
export class QrcodeUploadComponent implements OnInit {
  hiringBasicInfoId:any;
  serverId: any;
  vxUrl:any = null;
  toastDialog: boolean;
  toastInfo: any;
  isNeedAlert: boolean;
  dialogInfo: any;
  approveStatus:any;
  constructor(private activatedRoute: ActivatedRoute,
    private router: Router,public lifeCommonService:LifeCommonService,
    public myService:MyService,private changeDetectorRef: ChangeDetectorRef) { }

  ngOnInit() {
    const title = this.activatedRoute.snapshot.data[0]['title'];
    this.lifeCommonService.setTitle(title);
    this.hiringBasicInfoId = this.activatedRoute.snapshot.queryParams.hiringBasicInfoId?this.activatedRoute.snapshot.queryParams.hiringBasicInfoId:null;
    this.queryWholeInfo(this.hiringBasicInfoId)
  }

  selectPic(){
    if(this.approveStatus==null || this.approveStatus=='-1'){
      if(this.lifeCommonService.isWeiXin()){
        // 5.1 拍照、本地选图
        const t = this;
        wx.chooseImage({
          count: 1, // 默认9
          sizeType: ['original', 'compressed'], // 可以指定是原图还是压缩图，默认二者都有
          sourceType: ['album', 'camera'], // 可以指定来源是相册还是相机，默认二者都有
          success: function (res) {
            this.localId = res.localIds[0]; // 返回选定照片的本地ID列表，localId可以作为img标签的src属性显示图片
            const THIS = t;
            wx.uploadImage({
              localId: this.localId, // 需要上传的图片的本地ID，由chooseImage接口获得
              isShowProgressTips: 1, // 默认为1，显示进度提示
              success: function (response) {
                THIS.serverId = response.serverId; // 返回图片的服务器端ID
                const m = {
                  mediaId: response.serverId,
                  origin: 'ydLife'
                };
                THIS.myService.mediaGet(m).subscribe(async e => {
                  if (e['success']) {
                    THIS.vxUrl = e['data']['imgUrl'];
                    THIS.changeDetectorRef.markForCheck();
                    THIS.changeDetectorRef.detectChanges();
                  } else {
                    alert(e['message']);
                  }
                });
              }
            });
          }
        });
      }else{
        this.openPopInfo('请在微信端操作！')
      }
    }
  }

  next(){
    if(!this.vxUrl){
      this.openPopInfo('您的微信二维码不能为空，请在微信端上传！')
      return;
    }
      const param = {
        hiringBasicInfoId:this.hiringBasicInfoId,
        vxUrlQRcode:this.vxUrl
      }
      this.myService.saveWeChatQRcode(param).subscribe((res)=>{
        if(res['success']){
          this.router.navigate(['/bank_card'],{ queryParams: { hiringBasicInfoId:this.hiringBasicInfoId} });
        }else{
          this.toastDialog = true;
          this.toastInfo = {
            status: 1,
            msg: res['message'],
            timeout: 3000,
            align: 'center'
          };
        }
      })
    
  }

   // 打开弹窗
   openPopInfo(message) {
    this.isNeedAlert = true;
    this.dialogInfo = {
      title: null,
      content: { value: message, align: 'center' },
      footer: [{ value: '我知道了', routerLink: '', className: 'weui-dialog__btn_primary' }],
    };
  }

  // 关闭弹窗
  getPopInfo() {
    this.isNeedAlert = false;
  }

  queryWholeInfo(hiringBasicInfoId){
    this.myService.queryWholeInfo({hiringBasicInfoId:hiringBasicInfoId}).subscribe((res)=>{
       if(res['success']){
        this.approveStatus = res['data']['hiringBasicInfo']['approveStatus'];
        this.vxUrl =  res['data']['hiringBasicInfo']['wechatQRcodeOssPath']
       }else{
         this.vxUrl = null;
       }
    })
  }

  viewNext(){
    this.router.navigate(['/bank_card'],{ queryParams: { hiringBasicInfoId:this.hiringBasicInfoId} });
  }

  goBack(){
    history.go(-1)
  }
}
