import { Component, OnInit } from '@angular/core';
import { Router,ActivatedRoute } from "@angular/router";
import { MyService } from "../my.service";

@Component({
  selector: 'ydlife-file-list',
  templateUrl: './file-list.component.html',
  styleUrls: ['./file-list.component.scss']
})
export class FileListComponent implements OnInit {
  productDataMenuLists: Array<any>;
  productId:any;
  planId:any;
  categoryId:any;
  fileList:Array<any>;
  constructor(private router: Router,private myService:MyService,private activatedRoute: ActivatedRoute,) { }

  ngOnInit() {
    // window.location.href = urlItem['fileInfos'][0]['ossFilePath'];
    this.productId = this.activatedRoute.snapshot.queryParams.productId?this.activatedRoute.snapshot.queryParams.productId:null;;
    this.planId = this.activatedRoute.snapshot.queryParams.planId?this.activatedRoute.snapshot.queryParams.planId:null;
    this.categoryId = this.activatedRoute.snapshot.queryParams.categoryId?this.activatedRoute.snapshot.queryParams.categoryId:null;
    this.queryProductFile();
  }

  queryProductFile(){
    this.myService.queryProductFile({productId:this.productId,planId:this.planId}).subscribe((res)=>{
      if(res['success']){
        this.productDataMenuLists = res['data']['categoryInfos'];
        for(let i=0;i<this.productDataMenuLists.length;i++){
          if(this.categoryId == this.productDataMenuLists[i]['categoryId']){
            this.fileList = this.productDataMenuLists[i]['fileInfos']
          }
        }
      }
    })
  }
}
