import { Component, OnInit } from '@angular/core';
import { MyService } from '../../my.service';
import { ActivatedRoute,Router } from "@angular/router";
import { LifeCommonService } from "../../../common/life-common.service";

@Component({
  selector: 'ydlife-bank-card',
  templateUrl: './bank-card.component.html',
  styleUrls: ['./bank-card.component.scss']
})
export class BankCardComponent implements OnInit {
  hiringBasicInfoId:any;
  bankAccountOpening:string;
  bankAccountId:string;
  toastDialog:boolean;
  toastInfo:any;
  sureBankAccountId:string;
  isNeedAlert: boolean;
  dialogInfo: any;
  approvalIdentity:any;
  approveStatus:any;
  constructor(private activatedRoute: ActivatedRoute,
    private router: Router,public lifeCommonService:LifeCommonService,
    public myService:MyService) { }

  ngOnInit() {
    const title = this.activatedRoute.snapshot.data[0]['title'];
    this.lifeCommonService.setTitle(title);
    this.hiringBasicInfoId = this.activatedRoute.snapshot.queryParams.hiringBasicInfoId?this.activatedRoute.snapshot.queryParams.hiringBasicInfoId:null;
    this.approvalIdentity = this.activatedRoute.snapshot.queryParams.approvalIdentity?this.activatedRoute.snapshot.queryParams.approvalIdentity:null;
    this.queryWholeInfo(this.hiringBasicInfoId)
  }

  next(){
    if(this.bankAccountId != this.sureBankAccountId){
      this.openPopInfo('两次银行卡号不一致！');
      return;
    }
    const pattern = /^\d{16,19}$/;
    if(!pattern.test(this.bankAccountId)){
      this.openPopInfo('银行账号为16~19位数字,不能包含空格或其他符号');
      return;
    }
      const param = {
        hiringBasicInfoId:this.hiringBasicInfoId,
        bankAccountOpening:this.bankAccountOpening,
        bankAccountId:this.bankAccountId
      }
      this.myService.saveBankAccount(param).subscribe((res)=>{
        if(res['success']){
          // this.router.navigate(['/personal_statement'],{ queryParams: { hiringBasicInfoId:this.hiringBasicInfoId} });
          this.router.navigate(['/employee_salary'],{ queryParams: { hiringBasicInfoId:this.hiringBasicInfoId} });
        
        }else{
          this.toastDialog = true;
          this.toastInfo = {
            status: 1,
            msg: res['message'],
            timeout: 3000,
            align: 'center'
          };
        }
      })
  }

  bs(type) {
    this.lifeCommonService.scrollTo();
    if(type==2){
      if(this.bankAccountId){
        this.bankAccountId = this.bankAccountId.replace(/\D/g,'');
      }
    }
    if(type==3){
      if(this.sureBankAccountId){
        this.sureBankAccountId = this.sureBankAccountId.replace(/\D/g,'');
      }
    }
  }

  // 打开弹窗
  openPopInfo(message) {
    this.isNeedAlert = true;
    this.dialogInfo = {
      title: null,
      content: { value: message, align: 'center' },
      footer: [{ value: '我知道了', routerLink: '', className: 'weui-dialog__btn_primary' }],
    };
  }

  // 关闭弹窗
  getPopInfo() {
    this.isNeedAlert = false;
  }

  queryWholeInfo(hiringBasicInfoId){
    this.myService.queryWholeInfo({hiringBasicInfoId:hiringBasicInfoId}).subscribe((res)=>{
      if(res['success']){
        this.approveStatus = res['data']['hiringBasicInfo']['approveStatus'];
        this.bankAccountId = res['data']['hiringBasicInfo']['bankAccountId'];
        this.bankAccountOpening = res['data']['hiringBasicInfo']['bankAccountOpening'];
        this.sureBankAccountId = res['data']['hiringBasicInfo']['bankAccountId'];
      }
    })
  }

  viewNext(){
    this.router.navigate(['/employee_salary'],{ queryParams: { hiringBasicInfoId:this.hiringBasicInfoId,approvalIdentity:this.approvalIdentity} });
  
  }

  goBack(){
    history.go(-1)
  }
}
