import { Component, OnInit, Input, OnChanges } from '@angular/core';
import { Router } from "@angular/router";

@Component({
  selector: 'ydlife-toast',
  templateUrl: './toast.component.html',
  styleUrls: ['./toast.component.scss']
})
export class ToastComponent implements OnInit {
  @Input() toastInfo: any;
  @Input() routerLink: any;
  toastHidden: boolean;

  constructor(private router: Router) {
    // autoHidden 是否自动消失
    this.toastInfo = {
      status: 1,
      msg: '已完成',
      timeout: 3000,
      autoHidden: 1,
      align: 'justify'
    };
    this.toastHidden = true;
  }

  ngOnInit() {
    if (this.toastInfo.autoHidden == 0) {
      if (this.routerLink) {
        this.toastHidden = false;
        this.router.navigate(['/' + this.routerLink]);
      }
    } else {
      setTimeout(() => {
        this.toastHidden = false;
        if (this.routerLink) {
          this.router.navigate(['/' + this.routerLink]);
        }
      }, this.toastInfo.timeout)
    }
  }

  ngOnChanges() {
    this.toastHidden = true;
    setTimeout(() => {
      this.toastHidden = false;
      if (this.routerLink) {
        this.router.navigate(['/' + this.routerLink]);
      }
    }, this.toastInfo.timeout)
  }
}
