import {Injectable} from '@angular/core';
import {DatePipe} from '@angular/common';
import {Meta, Title} from '@angular/platform-browser';
import * as uuid from 'uuid';
@Injectable({
  providedIn: 'root'
})
export class LifeCommonService {

  constructor(private datePipe: DatePipe,
              private titleService: Title,
              private metaService: Meta) {
  }

  /**
   * 检测操作系统
   */
  checkOs() {
    let os;
    const isWin = (navigator.platform === 'Win32') || (navigator.platform === 'Windows');
    const isMac = (navigator.platform === 'Mac68K') ||
      (navigator.platform === 'MacPPC') ||
      (navigator.platform === 'Macintosh') ||
      (navigator.platform === 'MacIntel');
    if (/(iPhone|iPad|iPod|iOS)/i.test(navigator.userAgent)) {
      os = 1;
      return os; // 这是iOS平台下浏览器
    } else if (/android/i.test(navigator.userAgent)) {
      os = 2;
      return os; // 这是Android平台下浏览器
    } else if (isWin) {
      os = 3;
      return os; // 这是Android平台下浏览器
    } else if (isMac) {
      os = 4;
      return os; // 这是mac系统
    } else if (/Linux/i.test(navigator.userAgent)) {
      os = 5;
      return os; // 这是Linux平台下浏览器
    } else {
      os = 6;
      return os;
    }
  }

  /**
   * shareCode生成器
   */
  generateShareCode(jsonParams?: any) {
    const shareCode = {
      shareCode: uuid.v4(),
      shareType: '1',
      os: this.checkOs(),
      channel: '0',
      isOrder: 0,
      jsonParams: JSON.stringify(jsonParams)
    };
    return shareCode;
  }

  // 设置title
  setTitle(title) {
    this.titleService.setTitle(title);
  }

  // 更新meta标签
  updateMeta(keywords, description) {
    this.metaService.updateTag({content: keywords}, 'name=keywords');
    this.metaService.updateTag({content: description}, 'name=description');
  }
}
