import { Component, OnInit, Output, Input, EventEmitter } from '@angular/core';

@Component({
  selector: 'ydlife-picker',
  templateUrl: './picker.component.html',
  styleUrls: ['./picker.component.scss']
})
export class PickerComponent implements OnInit {
  @Input() provinceLists: Array<any>;
  // 地址选择到区还是市 ，省为1，市为2，区为3
  @Input() limitStep: number;
  @Output() selectedArea = new EventEmitter();
  cityLists: Array<any>;
  districtLists: Array<any>;
  provinceId: any;
  districtId: any;
  cityId: any;
  title: any;
  area: any;
  isNeedDistrict: boolean = true;
  areaLimitStep: number;
  isNeedCity: boolean = true;
  isNeedProvince: boolean = true;
  constructor() {
    this.title = '选择省份';
    this.area = {
      province: { id: null, value: null },
      city: { id: null, value: null },
      district: { id: null, value: null }
    }
  }

  ngOnInit() {
    console.log(this.provinceLists)
    if (this.isNeedDistrict) {
      this.areaLimitStep = 3;
    } else if (this.isNeedCity) {
      this.areaLimitStep = 2;
    } else if (this.isNeedProvince) {
      this.areaLimitStep = 1;
    } else {
      this.areaLimitStep = 3;
    }
  }


  //  选择省份
  selectProvince(provinceId, provinceName) {
    this.area.province.value = provinceName;
    this.area.province.id = this.provinceId = provinceId;
    this.cityLists = this.provinceLists.filter(item => item.provinceId === provinceId).pop().citys;
    this.title = '选择城市';
    if (this.limitStep === 1) {
      this.selectedArea.emit(this.area);
      return;
    }
  }

  //  选择城市
  selectCity(cityId, cityName) {
    this.area.city.value = cityName;
    this.area.city.id = this.cityId = cityId;
    this.title = '选择地区';
    if (this.limitStep === 2) {
      this.selectedArea.emit(this.area);
      return;
    }
    this.districtLists = this.cityLists.filter(item => item.cityId === cityId).pop().districtItem;
    if (!this.districtLists) {
      this.selectedArea.emit(this.area);
    }
  }

  //  选择地区
  selectDistrict(districtId, districtName) {
    this.area.district.value = districtName;
    this.area.district.id = this.districtId = districtId;
    this.selectedArea.emit(this.area);
  }

  //   取消
  cancel() {
    this.selectedArea.emit();
  }


}
