import { Component, OnInit } from '@angular/core';
import { MyService } from '../my.service';
import { LifeCommonService } from '../../common/life-common.service';

@Component({
  selector: 'ydlife-salary',
  templateUrl: './salary.component.html',
  styleUrls: ['./salary.component.scss']
})
export class SalaryComponent implements OnInit {
  practitionerIdEG: any;
  practitionerId: any;
  payScaleInfos: Array<any>;
  //控制弹框
  toastDialog: boolean;
  toastInfo: any;
  constructor(private myService: MyService, public lifeCommonService: LifeCommonService) { }

  ngOnInit() {
    this.practitionerIdEG = JSON.parse(localStorage.getItem('lifeCustomerInfo'))['practitionerIdEG'];
    this.practitionerId = JSON.parse(localStorage.getItem('lifeCustomerInfo'))['practitionerId']
    this.payScaleListQuery();
  }

  payScaleListQuery() {
    this.myService.payScaleListQuery({ practitionerIdEG: this.practitionerIdEG,practitionerId:this.practitionerId }).subscribe((res) => {
      if (res['success']) {
        this.payScaleInfos = res['data']['payScaleInfos'];
      } else {
        this.payScaleInfos = [];
      }
    })
  }

  //下载pdf
  getPdf(monShId,url) {
    if(url){
      window.open(url)
      // location.href = url;
    }else{
      this.myService.payScalePdf({ monShId: monShId, practitionerId: Number(this.practitionerId) }).subscribe((res) => {
        if (res['success']) {
          if (res['data']['url']) {
            window.open(res['data']['url'])
            // location.href = res['data']['url'];
          } else {
            this.toastDialog = true;
            this.toastInfo = {
              status: 1,
              msg: '暂无薪资单！',
              timeout: 3000,
              align: 'center'
            };
            return;
          }
        }
      })
    }
    
  }
}
