import { Component, OnInit } from '@angular/core';
import { LifeCommonService } from '../../common/life-common.service';
import { MyService } from '../../my/my.service'; 

@Component({
  selector: 'ydlife-product',
  templateUrl: './product.component.html',
  styleUrls: ['./product.component.scss']
})
export class ProductComponent implements OnInit {
  leftList:Array<any>;
  topList:Array<any>;
  rightList:Array<any>;
  leftSelectedId:number = null;
  constructor(private myService:MyService,public lifeCommonService:LifeCommonService) { }

  ngOnInit() {
    this.lifeCommonService.setTitle('产品库');
    this.tagViewQuery(2);
    this.tagViewQuery(6);
    // this.leftList = [
    //   {name:'全部',tagId:null},
    //   {name:'推荐',tagId:1},
    //   {name:'新品',tagId:2},
    //   {name:'意外',tagId:3},
    //   {name:'医疗',tagId:4},
    //   {name:'旅游',tagId:5},
    //   {name:'重疾',tagId:6},
    //   {name:'年金',tagId:7},
    //   {name:'定寿',tagId:8},
    //   {name:'终身寿',tagId:9},
    //   {name:'留学',tagId:10},
    //   {name:'高端医疗',tagId:11}
    // ]
  }

  switchCategory(id) {
    this.leftSelectedId = id;
  }

  //type：2左侧，6上侧，3筛选
  tagViewQuery(type){
    const param = {
      isActive:1,
      tagViewType:type
    }
    this.myService.tagViewQuery(param).subscribe((res)=>{
      if(res['success']){
        if(type == 2){
          this.leftList = res['data']['tagViewQueryInfos'];
        }else if(type == 6){
          this.topList = res['data']['tagViewQueryInfos']
        }else{
          this.rightList = res['data']['tagViewQueryInfos'];
        }
      }
    })
  }

}
