import { Component, OnInit } from '@angular/core';
import {MyService} from '../my.service';
import {ActivatedRoute} from "@angular/router";
import { LifeCommonService} from '../../common/life-common.service';
@Component({
  selector: 'ydlife-sales-detail',
  templateUrl: './sales-detail.component.html',
  styleUrls: ['./sales-detail.component.scss']
})
export class SalesDetailComponent implements OnInit {
  allPerformanceInfo:Array<any>;
  salesDetailList:Array<any>;
  salesDetailType:any;
  performanceList:Array<any>;
  constructor(private myService: MyService,private activatedRoute: ActivatedRoute,public lifeCommonService:LifeCommonService) { 
    this.performanceList = [
      {type: 'month',name:'本月'},
      {type: 'year',name:'本年度'}
    ]
  }

  ngOnInit() {
    this.salesDetailType = this.activatedRoute.snapshot.queryParams.type;
    console.log(this.salesDetailType)
    this.brokerInfoQuery();
  }

  //查询业绩
  brokerInfoQuery(){
    const practitionerId = JSON.parse(localStorage.getItem('lifeCustomerInfo'))['practitionerId'];
    this.myService.brokerInfoQuery({practitionerId:practitionerId}).subscribe((res)=>{
      if(res['success']){
        this.allPerformanceInfo = res['data']['commissionInfo'];
        if(this.salesDetailType === 'month'){
          this.salesDetailList = this.allPerformanceInfo['thisMonthInfo']['fortuneItemList'];
          console.log('month')
        }
        if(this.salesDetailType==='year'){
          this.salesDetailList = this.allPerformanceInfo['thisYearInfo']['fortuneItemList'];
          console.log('year')

        }
      }
    })
  }

  selectRang(e){
    this.salesDetailType = e;
    this.brokerInfoQuery()
  }
}
