import { Location } from '@angular/common';
import { Component, OnInit } from '@angular/core';
import { Router } from '@angular/router';

@Component({
  selector: 'ydlife-more-features',
  templateUrl: './more-features.component.html',
  styleUrls: ['./more-features.component.scss']
})
export class MoreFeaturesComponent implements OnInit {
  lifeCustomerInfo: any = JSON.parse(localStorage.getItem('lifeCustomerInfo')) ? JSON.parse(localStorage.getItem('lifeCustomerInfo')) : null;
  public feartureLists = [
    {key:'00',title:'营销工具',subItems:[
      {no:1,name:'线上投保',icon:'onlineInsurance',link:'',path:`https://${window.location.host}/index?source=dyd`,isOpen:true},
      {no:2,name:'产品库',icon:'product-market',link:'/product',path:'',isOpen:true},
      {no:3,name:'投核保知识库',icon:'insuranceKnowledgeBase',link:'/underwriting_knowledge',path:'',isOpen:true},
      {no:4,name:'计划书',icon:'proposals',link:'',path:'',isOpen:false},
      {no:5,name:'产品海报',icon:'productPoster',link:'/material',path:'',isOpen:true},
      {no:6,name:'文章分享',icon:'articleShare',link:'/article/null',path:'',isOpen:true},
      {no:7,name:'AI保险医生',icon:'aiDoctor',link:'',path:`https://${window.location.host}/questionnaire/#/index?campaign=AIRobot&task=AItask1&customerId=${this.lifeCustomerInfo.customerId}`,isOpen:true},
    ]},
    {key:'01',title:'保单服务',subItems:[
      {no:8,name:'我的保单',icon:'policyLists',link:'/salesDetail',path:'',isOpen:true},
      {no:9,name:'续期管理',icon:'renewalManagement',link:'/renewal_reminder',path:'',isOpen:true},
    ]}
    ,{
      key:'02',title:'客户管理',subItems:[
        {no:10,name:'成交客户',icon:'customers',link:'/customer',path:'',isOpen:true},
        {no:11,name:'潜在客户',icon:'potentialCustomers',link:'/business',path:'',isOpen:true},
      ]
    }
    ,{
      key:'03',title:'我的增员',subItems:[
        {no:12,name:'团队增员',icon:'teamIncreaseStaff',link:'/recruiting',path:'',isOpen:true},
        {no:13,name:'报聘审批',icon:'employmentApproval',link:'/approval_list',path:'',isOpen:true},
      ]
    }
    ,{
      key:'04',title:'我的展业',subItems:[
        {no:14,name:'目标设置',icon:'targetSetting',link:'/target',path:'',isOpen:true},
        {no:15,name:'我的日程',icon:'schedule',link:'/todo',path:'',isOpen:true},
        {no:16,name:'活动量统计',icon:'activityStatistics',link:'/scoreDeatil',path:'',isOpen:true},
        {no:17,name:'我的工号',icon:'jobNumber',link:'',path:'',isOpen:false},
        {no:18,name:'联合销售',icon:'jointSale',link:'/joint_sales',path:'',isOpen:true},
        {no:19,name:'客户告知书',icon:'customerNotification',link:'/business',path:'',isOpen:true},
        {no:20,name:'我的业绩',icon:'achievement',link:'',path:'',isOpen:false},
        {no:21,name:'我的薪资',icon:'salary',link:'/salary',path:'',isOpen:true},
        {no:22,name:'我的竞赛',icon:'competition',link:'',path:'',isOpen:false},
      ]
    }
    ,{
      key:'05',title:'银盾学院',subItems:[
        {no:23,name:'保险ABC',icon:'insuranceABC',link:'',path:`https://${window.location.host}/issue`,isOpen:true},
        {no:24,name:'岗前训',icon:'preJobTraining',link:'/prejobTraining',path:'',isOpen:true},
        {no:25,name:'新人训',icon:'newTraining',link:'/newTraining',path:'',isOpen:true},
        {no:26,name:'提升训',icon:'promotionTraining',link:'/advanceTraining',path:'',isOpen:true},
        {no:27,name:'CFFP培训',icon:'cffpTraining',link:'/cffpTraining',path:'',isOpen:true},
        {no:28,name:'产品培训',icon:'productTraining',link:'/productTraining',path:'',isOpen:true},
        {no:29,name:'我的培训',icon:'training',link:'',path:'',isOpen:false},
      ]
    }
    ,{
      key:'06',title:'我的团队',subItems:[
        {no:30,name:'我的团队',icon:'team',link:'/teamPanel',path:'',isOpen:true},
        {no:31,name:'团队业绩',icon:'teamPerformance',link:'/teamRank',path:'',isOpen:true},
        {no:32,name:'团队晋升考核',icon:'teamPromotionAssessment',link:'',path:'',isOpen:false},
        {no:33,name:'团队PEP',icon:'temPEP',link:'/teamPanel/teamSalesScore',path:'',isOpen:true},
        {no:34,name:'团队学习',icon:'teamLearning',link:'',path:'',isOpen:false},
        {no:35,name:'团队竞赛',icon:'teamCompetition',link:'',path:'',isOpen:false},
      ]
    }
  
  
  
  
  
  
  
  
  
  
  
  
  
  ]

  public state = {
    modal1:false
  }

  onClose(key) {
    this.state[key] = false;
  }
  featureSelect(item){
    if(!item.isOpen){
      this.state['modal1'] = true;
    }
    if(item.path){
      window.open(item.path);
    }else if(item.link){
      this.router.navigate([`./${item.link}`]);
    }
  }
  // 返回上一页
  goBack(){
    this.location.back()
  }
  constructor(private router:Router,private location:Location) { }

  ngOnInit() {

  }

}
